/*********
Inverts the source color
Use with GenericPostProcessShaderClass.
**********/
texture SceneBuffer: SceneTexture;
texture InputBuffer: InputTexture;

sampler2D SceneBufferSampler =
sampler_state
{
    Texture = <SceneBuffer>;
    AddressU = Clamp;
    AddressV = Clamp;
    MinFilter = Point;
    MagFilter = Linear;
    MipFilter = Linear;
};

sampler2D InputBufferSampler = sampler_state
{
    Texture = <InputBuffer>;
    AddressU = Clamp;
    AddressV = Clamp;
    MinFilter = Point;
    MagFilter = Linear;
    MipFilter = Linear;
};

float4 InvertPS(float2 Tex: TEXCOORD0): COLOR0
{
    return 1.0f - tex2D(InputBufferSampler, Tex);
}

technique SceneShader
{
    pass p0
    {
        PixelShader = compile ps_1_1 InvertPS();
    }
}