#ifndef INCLUDE_MAPFIX
#define INCLUDE_MAPFIX

#include "da_event.h"
#include "da_gamefeature.h"
#include "da_gameobj.h"

class ZoneFixClass {
public:
	ZoneFixClass(int ObjectID, const char *Zone, const char *Script, const char *Parameter, Vector3 Postition, Vector3 Size, float Facing);
	const int &Get_ID();
	const StringClass &Get_Script();
	const StringClass &Get_Zone();
	const StringClass &Get_Parameter();
	const Vector3 &Get_Position();
	const Vector3 &Get_Size();
	const float &Get_Facing();
	void Set_ID(int ID) { ObjectID = ID; }
	void Set_Script(const char *Script) { this->Script = Script; }
private:
	int ObjectID;
	StringClass Script;
	StringClass Zone;
	StringClass Parameter;
	Vector3 Position;
	Vector3 Size;
	float Facing;
};

class MapFix : public DAEventClass, public DAGameFeatureClass {
public:
	virtual void Init();
	virtual ~MapFix();
	virtual void Settings_Loaded_Event();
	virtual void Object_Created_Event(GameObject *obj);
	virtual void Level_Loaded_Event();
	virtual void Timer_Expired(int Number, unsigned int Data);
	bool ShowZones_Chat_Command(cPlayer *Player,const DATokenClass &Text,TextMessageEnum ChatType);
	bool HideZones_Chat_Command(cPlayer *Player,const DATokenClass &Text,TextMessageEnum ChatType);
	bool DisplayZones_Chat_Command(cPlayer *Player, const DATokenClass &Text, TextMessageEnum ChatType);
	bool DestroyZones_Chat_Command(cPlayer *Player, const DATokenClass &Text, TextMessageEnum ChatType);
	bool CreateZones_Chat_Command(cPlayer *Player, const DATokenClass &Text, TextMessageEnum ChatType);
	bool MoveMct_Chat_Command(cPlayer *Player, const DATokenClass &Text, TextMessageEnum ChatType);
	bool DestroyMct_Chat_Command(cPlayer *Player, const DATokenClass &Text, TextMessageEnum ChatType);
	bool CreateMct_Chat_Command(cPlayer *Player, const DATokenClass &Text, TextMessageEnum ChatType);
	bool Fly_Chat_Command(cPlayer *Player, const DATokenClass &Text, TextMessageEnum ChatType);
	GameObject *MCTOBJ;
	Vector3 MCTPOS;
	//static GameObject *Get_MCTOBJ() { return MCTOBJ; }


protected:
	void INICreate_Debug(GameObject *obj);
	void INICreate(GameObject *obj);
	void WriteINI(StringClass Format, ...);
	void Create_Zones();
	void Create_ZoneList();
	void Destroy_Object(int objectid);
	void Destroy_Zones();
	void Destroy_LaserWalls();
	void DisplayZoneList();
	void DisplayZoneList2();
	void Delete_ZoneList_Entry(int Position);
	void Delete_ZoneList_Entry_By_ID(int ObjectID);
	void Delete_ZoneList();
	void Hide_Zones();
	void Gameover_Loop();
	void Gameover_Loop2();
	void Gameover_Loop_Timer();
	void Mct_Fix();
	void Create_VehicleBlocker(Vector3 Position);

private:
	int zonecount;
	int lasercount;
	bool mapprint;
	const char *Name;
	StringClass Section;
	bool DestroyZones;
	bool DestroyLaserWalls;
	bool MctFix;
	bool CreateINI;
	bool CreateZone;
	bool StaticZoneList;
	bool FirstMap;
	bool EntireRotationGameover;
	bool Destruct;
	bool VehicleBlocker;
	bool ZoneEntrys;
	DynamicVectorClass<int> ZoneObjectList;
	DynamicVectorClass<int> LaserWalls;
	DynamicVectorClass<ZoneFixClass*> ZoneList;
};

/*
class MCTObserverClass : public DAGameObjObserverClass {
public:
	MCTObserverClass();
	MCTObserverClass(Vector3 pos) {MCTPos = pos;}
	~MCTObserverClass();
	virtual void Init();
	const char *Get_Name() { return "MCTObserverClass"; } //This is required.
	virtual void Timer_Expired(GameObject *obj, int Number);
	Vector3 MCTPos;

};
*/


class MCTObserverClass : public DAGameObjObserverClass, public MapFix  {
public:
	MCTObserverClass();
	void Damage_Received(ArmedGameObj *Damager, float Damage, unsigned int Warhead, float Scale, DADamageType::Type Type);
	void Kill_Received(ArmedGameObj *Killer, float Damage, unsigned int Warhead, float Scale, DADamageType::Type Type);
	void Poked(cPlayer *Player);
	void Destroyed();
	virtual void Timer_Expired(GameObject *obj, int Number);
	const char *Get_Name() { return "MCTObserverClass"; }
	
	BuildingGameObj *Building;
	GameObject *Mct;
	//StringClass Model;

	MCTObserverClass(BuildingGameObj *obj);
	MCTObserverClass(GameObject *obj);
	void Set_Position(Vector3 Position) {
		Commands->Set_Position(Mct, Position);
	}
};



#endif