#ifndef STTIBCRYSTAL_H
#define STTIBCRYSTAL_H

//#if ISDEV()
//#define TIBMSG
//#endif

// Forward
class gzTiberiumCrystal;


class gzSettingsTibCrystal : public stSettingsBase {
public:
	void Delete();
	void Load();

	bool				m_enable;
	float				m_successAmount;
	float				m_successCarrierAmount;
	aStringArray		m_modelList;
	int					m_spawnMin; // Minute
	int					m_spawnMax; // Minute
	int					m_growMin; // Second
	int					m_growMax; // Second
	float				m_liveTime; // Minute
	unsigned int		m_dropCountMax;
	float				m_dropLive; // Second
	float				m_tibPoisonDamageTime; // Second
	float				m_tibPoisonDamage;
	aVector<nc_Vector3> m_posList;
};

class gzTibCrystalManager : public EventHandler, public gzManagerEvent, public gzSettingsEvent {
	float m_nextSpawnCheck;
	gzTiberiumCrystal *m_crystal;
	nc_PowerUpGameObj *m_flags[2];
public:
	const char *GetName()
	{
		return "gzTibCrystalManager";
	};
	void Delete() { };
	gzTibCrystalManager();
	void Think();
	void Object_PowerupGrant(gzEventObjectPowerupGrant &);
	void ChildObjDeletion(gzBase *);
	void Settings_Loaded();
	nc_PowerUpGameObj *GetFlag(int team);

	gzSettingsTibCrystal *m_settings;
};
extern gzTibCrystalManager *gzTibCrystalMgr;

struct gzPickerWeaponData {
	nc_WeaponDefinitionClass *WeaponDef;
	int Inventory;
	int Loaded;
};
class gzTiberiumCrystal : public EventHandler {
	unsigned int		m_crystalId;
	unsigned int		m_crystalBoneId;
	int					m_posId;
	unsigned int		m_state;
	unsigned int		m_dropCount;
	float				m_dropSpoilCounter;
	float				m_damagePickerCounter;
	float				m_liveCounter;
	float				m_nextGrowCounter;
	//float				m_clearWeaponsCounter;
	bool				m_harvestable;
	gzPlayer			*m_picker;
	unsigned int		m_pickerSoldierId;
	aVector<gzPickerWeaponData> m_pickerWeapons;
	nc_PowerUpGameObj	*m_flag;

#if VERC(1, 0, 1)
	float               m_pickupBlockCounter[128];
#endif
public:
	const char *GetName()
	{
		return "gzTiberiumCrystal";
	};
	void Delete();
	gzTiberiumCrystal();
	void Level_Ended();
	void Think();
	void Player_Left(gzEventPlayerBase &);
	void Player_Purchase(gzEventPlayerPurchase &);
	void Object_Killed(gzEventObjectKill &);
	void Object_Transition(gzEventObjectTransition &);
	void Object_PowerupGrant(gzEventObjectPowerupGrant &);
	void Drop();
	void RestoreWeapons();
	void NotifyFlagDeletion();

	unsigned int GetCrystalId();
	void SetCrystalId(unsigned int id);
	unsigned int GetCrystalBoneId();
	void SetCrystalBoneId(unsigned int id);
	int GetPosId();
	void SetPosId(int id);
	void SetLiveTime(float secs);
	gzPlayer *GetPicker();
	void SetPickupBlock(int pId, float secs) { this->m_pickupBlockCounter[pId] = secs; };
};

#endif
