#ifndef STVETERAN_H
#define STVETERAN_H

#if ISDEV()
#define VETMSG
#endif

class gzVeteranClass;

struct gzVeteranPointsDefStruct {
	aString name;
	float   damage;
	float   destroy;
	float   repair;
	float   suicide;
	float   stealByEnemy; // Vehicles only
};
struct gzVeteranPresetDefStruct {
	gzVeteranPointsDefStruct	*Points;
	nc_DefinitionClass			*Definition;
};
struct gzVeteranLevelDefStruct {
	aString		  Name;
	unsigned int  Level;
	float         AddHealth;
	float         AddArmor;
	float         Discount;
	float         SoldierHealthRegeneration;
	float         VehicleHealthRegeneration;
	float         RequiredPoints;
	float         RequiredScore;
	unsigned long RequiredGameTime;
	unsigned long IncreaseRequirementStart;
	unsigned long IncreaseRequirementInterval;
	float         IncreaseRequirementPercent;
	bool          IncreaseRequirementUsePromoteTime;
	bool          CanPromoteByCrate;
};
class gzSettingsVeteranClass : public stSettingsBase {
public:
	void Delete();
	void Load();

	bool  m_enable;
	float m_c4Points[3][2];
	int   m_minPlayersIncreaseRequirement;
	aVector<gzVeteranPresetDefStruct *> m_presets;
	aVector<gzVeteranLevelDefStruct *>  m_level;
	aVector<gzVeteranPointsDefStruct *> m_points;
};

class gzVeteranManagerClass : public EventHandler, public gzSettingsEvent {
	gzSettingsVeteranClass *m_settings;
public:
	const char *GetName()
	{
		return "gzVeteranManagerClass";
	};
	void Delete();
	void Settings_Loaded();
	gzVeteranManagerClass();
	void Level_Loaded();
	void Object_C4Creation(gzEventObjectC4Creation &);
	gzSettingsVeteranClass *GetSettings();
	const gzVeteranPresetDefStruct *FindPresetSetting(const char *);
};
extern gzVeteranManagerClass *gzVeteranMgr;

class gzVeteranClass : public EventHandler {
	gzPlayer					*m_owner;
	float						m_points;
	gzVeteranLevelDefStruct		*m_currLevel;
	gzVeteranLevelDefStruct		*m_nextLevel;
	float						m_promoteTime;
public:
	const char *GetName()
	{
		return "gzVeteranClass";
	};
	void Delete() { };
	gzVeteranClass(gzPlayer *owner);
	void Level_Loaded();
	void Player_Purchase(gzEventPlayerPurchase &);
	void AddPoints(float points);
	bool Promote();
	float GetMultipler();
	gzPlayer *GetOwner();
	gzVeteranLevelDefStruct *GetCurrentLevel();
	gzVeteranLevelDefStruct *GetNextLevel();
	float GetPoints();
};


/*************/
/* Observers */
/*************/
class gzObserverVeteranBeacon : public nc_ScriptImpClass {
	void Created(nc_ScriptableGameObj *obj);
	void Custom(nc_ScriptableGameObj *obj, int message, int param, nc_ScriptableGameObj *sender);
	void Damaged(nc_ScriptableGameObj *obj, nc_ScriptableGameObj *damager, float damage);
	void Killed(nc_ScriptableGameObj *obj, nc_ScriptableGameObj *shooter);
	const gzVeteranPresetDefStruct* m_data;
	float m_damage[128];
	float m_maxHealth;
};

class gzObserverVeteranC4 : public nc_ScriptImpClass {
	void Created(nc_ScriptableGameObj *obj);
	void Custom(nc_ScriptableGameObj *obj, int message, int param, nc_ScriptableGameObj *sender);
	void Damaged(nc_ScriptableGameObj *obj, nc_ScriptableGameObj *damager, float damage);
	void Killed(nc_ScriptableGameObj *obj, nc_ScriptableGameObj *shooter);
	nc_C4GameObj* m_c4;
	float         m_damage[128];
	float         m_maxHealth;
};

class gzObserverVeteranBuilding : public nc_ScriptImpClass {
	void Created(nc_ScriptableGameObj *obj);
	void Custom(nc_ScriptableGameObj *obj, int message, int param, nc_ScriptableGameObj *sender);
	void Damaged(nc_ScriptableGameObj *obj, nc_ScriptableGameObj *damager, float damage);
	void Killed(nc_ScriptableGameObj *obj, nc_ScriptableGameObj *shooter);
	void Timer_Expired(nc_ScriptableGameObj *obj, int number);
	const gzVeteranPresetDefStruct* m_data;
	float m_damage[128];
	float m_repair[128];
	float m_allowRepair;
	float m_totalDamage;
};

class gzObserverVeteranSoldier : public nc_ScriptImpClass {
	void Created(nc_ScriptableGameObj *obj);
	void Custom(nc_ScriptableGameObj *obj, int message, int param, nc_ScriptableGameObj *sender);
	void Damaged(nc_ScriptableGameObj *obj, nc_ScriptableGameObj *damager, float damage);
	void Killed(nc_ScriptableGameObj *obj, nc_ScriptableGameObj *shooter);
	void Timer_Expired(nc_ScriptableGameObj *obj, int number);
	const gzVeteranPresetDefStruct* m_data;
	float              m_damage[128];
	float              m_repair[128];
	float              m_allowRepair;
	float              m_totalDamage;
	nc_SoldierGameObj* m_soldier;
};

class gzObserverVeteranVehicle : public nc_ScriptImpClass {
	void Created(nc_ScriptableGameObj *obj);
	void Custom(nc_ScriptableGameObj *obj, int message, int param, nc_ScriptableGameObj *sender);
	void Damaged(nc_ScriptableGameObj *obj, nc_ScriptableGameObj *damager, float damage);
	void Killed(nc_ScriptableGameObj *obj, nc_ScriptableGameObj *shooter);
	void Timer_Expired(nc_ScriptableGameObj *obj, int number);
	const gzVeteranPresetDefStruct* m_data;
	float              m_damage[128];
	float              m_repair[128];
	float              m_allowRepair;
	float              m_totalDamage;
	nc_VehicleGameObj* m_vehicle;
	gzPlayer*           m_purchaser;
	bool               m_stolen;
};

#endif
