#include "stinc.h"
#include "stmisc.h"
#include "stconsolecommands.h"
#include "stplayer.h"
#include "sttestzone.h"

gzTestZoneManager *gzTestZoneMgr = NULL;
gzTestZoneManager::gzTestZoneManager()
{
	this->RegisterEvent(EVT_GAME_LEVEL_LOADED);
}
void gzTestZoneManager::Delete()
{
	for (unsigned int i = 0; i < this->m_blocker.Count(); i++)
	{
		this->m_blocker[i]->Preset.Free_String();
		delete this->m_blocker[i];
	}
	this->m_blocker.Clear();
	this->m_spawn.Clear();
}
void gzTestZoneManager::Level_Loaded()
{
	for (unsigned int i = 0; i < this->m_blocker.Count(); i++)
	{
		this->m_blocker[i]->Preset.Free_String();
		delete this->m_blocker[i];
	}
	this->m_blocker.Clear();
	this->m_spawn.Clear();

	aTextConfig* cfg = new aTextConfig("TestZone.ini");
	for (int i = 1; i; i++)
	{
		aString query[5];
		query[0].Printf("\"%s\".TZ%d_P", cGame->MapName.m_Buffer, i);
		query[1].Printf("\"%s\".TZ%d_R", cGame->MapName.m_Buffer, i);
		query[2].Printf("\"%s\".TZ%d_X", cGame->MapName.m_Buffer, i);
		query[3].Printf("\"%s\".TZ%d_Y", cGame->MapName.m_Buffer, i);
		query[4].Printf("\"%s\".TZ%d_Z", cGame->MapName.m_Buffer, i);

		if (cfg->GetData(query[1], -999.0f).ToDouble() != -999.0f &&
			cfg->GetData(query[2], -999.0f).ToDouble() != -999.0f &&
			cfg->GetData(query[3], -999.0f).ToDouble() != -999.0f &&
			cfg->GetData(query[4], -999.0f).ToDouble() != -999.0f)
		{
			gzTestZoneBlockerStruct *data = new gzTestZoneBlockerStruct;
			data->Preset = cfg->GetData(query[0], "");
			data->Position.X = (float)cfg->GetData(query[2], -999.0f).ToDouble();
			data->Position.Y = (float)cfg->GetData(query[3], -999.0f).ToDouble();
			data->Position.Z = (float)cfg->GetData(query[4], -999.0f).ToDouble();
			data->Rotation = (float)cfg->GetData(query[1], -999.0f).ToDouble();
			this->m_blocker.Add(data);
		}
		else
			break;
	}
	for (int i = 1; i; i++)
	{
		aString query[3];
		query[0].Printf("\"%s\".TZS%d_X", cGame->MapName.m_Buffer, i);
		query[1].Printf("\"%s\".TZS%d_Y", cGame->MapName.m_Buffer, i);
		query[2].Printf("\"%s\".TZS%d_Z", cGame->MapName.m_Buffer, i);

		nc_Vector3 pos;
		if (cfg->GetData(query[0], -999.0f).ToDouble() != -999.0f &&
			cfg->GetData(query[1], -999.0f).ToDouble() != -999.0f &&
			cfg->GetData(query[2], -999.0f).ToDouble() != -999.0f)
		{
			pos.X = (float)cfg->GetData(query[0], -999.0f).ToDouble();
			pos.Y = (float)cfg->GetData(query[1], -999.0f).ToDouble();
			pos.Z = (float)cfg->GetData(query[2], -999.0f).ToDouble();
			this->m_spawn.Add(pos);
		}
		else
			break;
	}
	delete cfg;
	this->m_active = false;
}
void gzTestZoneManager::Process()
{
	if (!this->m_active && this->m_blocker.Count() > 0)
	{
		this->m_active = true;
		for (unsigned int i = 0; i < this->m_blocker.Count(); i++)
		{
			nc_PhysicalGameObj *Blocker = nc_ObjectLibraryManager::Create_Object(this->m_blocker[i]->Preset.GetString())->As_PhysicalGameObj();
			if (Blocker)
			{
				Blocker->Set_Position(this->m_blocker[i]->Position);
				gzCommands->Set_Facing(Blocker, this->m_blocker[i]->Rotation);
				gzCommands->Attach_Script(Blocker,"M00_Damage_Modiefer_DME","0,1,1,0,0");
				this->m_blocker[i]->Id = Blocker->NetworkID;
			}
		}
		stConsole::In("amsg A test is a in progress. Please do not interfere.");
	}
	else
	{
		for (unsigned int i = 0; i < this->m_blocker.Count(); i++)
			gzCommands->Find_Object(this->m_blocker[i]->Id)->Set_Delete_Pending();
		this->m_active = false;
		stConsole::In("amsg The test has been completed.");
	}
}
void gzTestZoneManager::Move_Player_To_TestZone(int pID)
{
	if (this->m_active && this->m_spawn.Count() > 0)
	{
		nc_cPlayer *pData = nc_cPlayerManager::Find_Player(pID);
		if (!pData || !pData->Owner.Reference)
			return;
		pData->Owner.Reference->obj->As_PhysicalGameObj()->Set_Position(this->m_spawn[stRandom.Get_Int(0, this->m_spawn.Count() - 1)]);
		pData->Owner.Reference->obj->Set_Object_Dirty_Bit(nc_DB_FREQUENT, true);
		PagePlayer(pData->PlayerId, "You're being moved to the Test Zone.");
	}
}
bool gzTestZoneManager::IsActive()
{
	return this->m_active;
}

class TestZoneConsoleFunction : public gzConsoleCommand {
public:
	char *Get_Name() {
		return "testzone";
	}
	char *Get_Alias() {
		return "tz";
	}
	char *Get_Help() {
		return "TESTZONE - Disable/Enable the test zone.";
	}
	void Activate(char *text) {
		gzTestZoneMgr->Process();
	}
};
TestZoneConsoleFunction testzone;

class GoTestZoneConsoleFunction : public gzConsoleCommand {
public:
	char *Get_Name() {
		return "gotestzone";
	}
	char *Get_Alias() {
		return "gtz";
	}
	char *Get_Help() {
		return "gotestzone <player id> - Move player to the test position.";
	}
	void Activate(char *text) {
		if (!*text)
			return;
		gzTestZoneMgr->Move_Player_To_TestZone(atoi(text));
	}
};
GoTestZoneConsoleFunction gotestzone;
