#ifndef STMANAGER_H
#define STMANAGER_H

#include "stbase.h"
#include "stsetting.h"

#define __DEV__
#define __VER_MAJOR 1
#define __VER_MINOR 1
#define __VER_MINOR2 0

//#define __ALPHA 2
//#define __BETA 2

#ifdef __DEV__
#define ISDEV() 1
#else
#define ISDEV() 0
#endif

#if ISDEV()
#define DEVMSG
#endif

#define DEBUGLOG

#define STGM_DB     "stgm.dat"

class gzInitClass {
public:
	gzInitClass();
	~gzInitClass();
};
extern gzInitClass *gzInit;

class gzUnloadClass {
public:
	~gzUnloadClass();
};

class gzManagerClass : public EventHandler {
public:
	const char *GetName()
	{
		return "gzManagerClass";
	};
	void Delete();
	gzManagerClass();
	void Level_Loaded();
	void Think();
	static nc_ScriptableGameObj *Get_Explosion_Obj()
	{
		if (gzManagerClass::m_ExplosionObj)
			return *(nc_ScriptableGameObj **)gzManagerClass::m_ExplosionObj;
		return NULL;
	};
	
	static bool m_initial;
	static nc_ScriptableGameObj *m_ExplosionObj;
	static int m_sFps;
};
extern gzManagerClass *gzManager;

class stDbManager : public aSQLite3 {
public:
	stDbManager();
	~stDbManager();
	void PrintError();
};
extern stDbManager *stDb;

class stConsole {
public:
	static void In(const char *msg, ...);
	static void Out(const char *msg, ...);
};

#endif
