/*
	STGM core include file
*/

#ifndef STINC_H
#define STINC_H

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <direct.h>
#include <time.h>
#include <sys/stat.h>
#include <assert.h>
#include <dbghelp.h>
#include <string>
#include "mmgr.h"

// Disable compiler warnings
#pragma warning(disable: 4127 4189 4200)

// aLib
#define VECTOR_USE_CRT 0

#include "aLib.h"
#include "aVector.h"
#include "aList.h"
#include "aThread.h"
#include "aString.h"
#include "aSocket.h"
#include "aRegex.h"
#include "aToken.h"
#include "aSQLite3.h"
#include "aTextConfig.h"
#include "aRandom.h"
#include "aDateTime.h"
#include "aNetTools.h"

// STGM
#include "stbase.h"
#include "stmanager.h"
#include "steventbase.h"
#include "stevent.h"
#include "stbhs.h"

#ifdef __ALPHA
#define VERC_A(aVer) (__ALPHA >= aVer) ? 1 : 0
#else
#define VERC_A(aVer) 1
#endif

#ifdef __BETA
#define VERC_B(bVer) (__BETA >= bVer) ? 1 : 0
#else
#define VERC_B(bVer) 1
#endif

// Marco for first version to enable the code block
#define VERC(major, minor, minor2) (((__VER_MAJOR * 100) + (__VER_MINOR * 10) + (__VER_MINOR2)) >= ((major * 100) + (minor * 10) + (minor2))) ? 1 : 0

// Marco for last version to enable the code block
#define VERCL(major, minor, minor2) (((__VER_MAJOR * 100) + (__VER_MINOR * 10) + (__VER_MINOR2)) <= ((major * 100) + (minor * 10) + (minor2))) ? 1 : 0

#define gzDEPRECATED __declspec(deprecated)

static aCriticalSection gzCritical;
#endif
