#ifndef STBASE_H
#define STBASE_H

#define WIN32_LEAN_AND_MEAN
#include <windows.h>

#define BASE_START_ID	10000

class gzManagerEvent;
class gzBase {
	int					m_Id;
	bool				m_deletePending;
	gzManagerEvent		*m_childOwner;
	unsigned long		m_createTime;
public:
	gzBase();
	virtual ~gzBase();
	virtual const char *GetName() = 0;
	virtual void Delete() = 0;
	virtual void SetDeletePending();
	
	int GetId();
	bool IsDeletePending();
	unsigned long GetCreateTime();
	gzManagerEvent *GetChildOwner();
	void SetChildOwner(gzManagerEvent *owner);
};

class gzBaseManager {
public:
	static void Level_Loaded();
	static void Unload();
	static void Think();
	static aVector<gzBase *> m_objList;
	static aVector<gzBase *> m_deletePendingList;
	static int m_nextId;
	static double m_mapDuration;
};

#endif
