#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <time.h>
#include <sys/stat.h>
#include "scripts.h"
#include "fds.h"
#include "Hooks_Base.h"
#include "TextFilter.h"
#include "ncRegEx.h"
#include "ncString.h"
#include "ncToken.h"

ncDynamicVector<TextFilterStruct *> FilterList;
ncDynamicVector<ncWideString> MuteList;
unsigned long bhsChat_Call;
unsigned long bhsChat_Var;
time_t confModTime = 0;

bool Chat_Hook(cCsTextObj *CsTextObj)
{
	// This DLL is not intended to catch messages other than "To all" and "To team"
	if (CsTextObj->Sender > 0 && (CsTextObj->Type == 0 || CsTextObj->Type == 1))
	{
		cPlayer *pData = cPlayerManager::Find_Player(CsTextObj->Sender);
		if (pData)
		{
			for (int i = 0; i < MuteList.Count(); i++)
			{
				if (MuteList[i] == pData->PlayerName.m_Buffer)
					return false;
			}
			for (int i = 0; i < FilterList.Count(); i++)
			{
				// Type comparsion
				if ((CsTextObj->Type == 0 && (FilterList[i]->Type & MSG_ALL) == MSG_ALL) ||
					(CsTextObj->Type == 1 && (FilterList[i]->Type & MSG_TEAM) == MSG_TEAM))
				{
					for (int j = 0; j < FilterList[i]->String.Count(); j++)
					{
						if (FilterList[i]->Enable == true)
						{
							bool Match = false;
							// Normal, just pure string comparsion
							if (FilterList[i]->CompareType == TYPE_NORM)
								Match = (FilterList[i]->String[j] == CsTextObj->Message.m_Buffer) ? true : false;

							// Wildcards
							else if (FilterList[i]->CompareType == TYPE_WILDCARD)
								Match = wwildcmp(FilterList[i]->String[j].Get_Buffer(),CsTextObj->Message.m_Buffer);

							// Regex
							else if (FilterList[i]->CompareType == TYPE_REGEX)
							{
								ncRegEx reg(CsTextObj->Message.m_Buffer);
								Match = reg.Compile(FilterList[i]->String[j].Get_Buffer());
							}

							// Matched
							if (Match == true)
							{
								if ((FilterList[i]->Options & OPT_LOG) == OPT_LOG) // LOG option
								{
									char renlog[24];
									time_t rawtime;
									tm *timeinfo;
									time(&rawtime);
									timeinfo = localtime(&rawtime);
									sprintf(renlog,"renlog_%d-%d-%04d.txt",timeinfo->tm_mon +1,timeinfo->tm_mday,timeinfo->tm_year + 1900);
									FILE *renlogFile = fopen(renlog,"a");
									if (renlogFile) // Able to open file
									{
										fprintf(renlogFile,"[%02d:%02d:%02d] ",timeinfo->tm_hour,timeinfo->tm_min,timeinfo->tm_sec);
										if (CsTextObj->Type == 1) // Team message
											fprintf(renlogFile,"[Team] ");
										if (cPlayerManager::Find_Player(CsTextObj->Sender)) // Player exists
											fprintf(renlogFile,"%S: ",cPlayerManager::Find_Player(CsTextObj->Sender)->PlayerName.m_Buffer);
										else // Player does not exist
											fprintf(renlogFile,"(null): ");
										char *msg = new char[CsTextObj->Message.Get_Length() *2 +1];
										wcstombs(msg,CsTextObj->Message.m_Buffer,CsTextObj->Message.Get_Length());
										fwrite(msg,1,wcslen(CsTextObj->Message.m_Buffer),renlogFile);
										fprintf(renlogFile,"\n");
										delete [] msg;
										fclose(renlogFile);
									}
								}
								if ((FilterList[i]->Options & OPT_BHSHOOK) == OPT_BHSHOOK) // bhs.dll ChatHook option
								{
									if (bhsChat_Call != 0 && bhsChat_Var != 0) // Offsets from bhs.dll are good
									{
										/* Can't use cCsTextObj because it has no "operator=" */
										*(unsigned long *)bhsChat_Var = (unsigned long)CsTextObj;

										/* Initial bhs.dll chathook call */
										typedef void (*_ChatHook)();
										_ChatHook ChatHook = (_ChatHook)bhsChat_Call;
										ChatHook();
									}
								}
								return false;
							}
						}
					}
				}
			}
		}
	}
	return true;
}

bool Radio_Hook(CSAnnouncement *Radio)
{
	for (int i = 0; i < MuteList.Count(); i++)
	{
		cPlayer *pData = cPlayerManager::Find_Player(Radio->ID);
		if (pData)
		{
			if (MuteList[i] == pData->PlayerName.m_Buffer)
				return false;
		}
	}
	return true;
}

void Load_Config()
{
	unsigned char CallByte[] = { 0xE8 };
	unsigned char JmpByte[] = { 0xE9 };
	if (!memcmp((void *)0x4B5C73,JmpByte,1) && // Make sure the bhs.dll chathook exists
		!memcmp((void *)((*(unsigned long *)0x4B5C74 + 0x4B5C74 +4) +6),CallByte,1) && // Make sure it's "call"
		((*(unsigned long *)0x4B5C74) + 0x4B5C74 +4) >= 0x45000000) // Make sure the jmp offset is in bhs.dll offset range
	{
#ifdef __DEV__
		Console::Out("bhs.dll Chat hook detected. Getting offsets...\n");
#endif
		unsigned long bhsChatHook = *(unsigned long *)0x4B5C74 + 0x4B5C74 +4;
		bhsChat_Call = *(unsigned long *)(bhsChatHook +7) + (bhsChatHook +6) +5;
		bhsChat_Var = *(unsigned long *)(bhsChatHook +2);
#ifdef __DEV__
		Console::Out("\tFunction: 0x%X\n\tVariable: 0x%X\n\n",bhsChat_Call,bhsChat_Var);
#endif
	}
	else
	{
#ifdef __DEV__
		Console::Out("Failed to determine offsets. Either the hook offset or the \"jmp\" structure has changed.\n");
#endif
		bhsChat_Call = 0;
		bhsChat_Var = 0;
	}
	FILE *confFile = fopen("TextFilter.cfg","r");
	if (confFile == NULL)
	{
		Console::Out("TextFilter.cfg not found.\n");
		return;
	}
#ifndef __DEV__
	struct stat attrib;
	stat("TextFilter.cfg", &attrib);
	if (attrib.st_mtime != confModTime) // Modify time changed
	{
#ifdef __DEV__
		Console::Out("Config file changed. Reloading...\n");
#endif
		confModTime = attrib.st_mtime;
#endif
		for (int i = 0; i < FilterList.Count(); i++)
		{
			for (int j = 0; j < FilterList[i]->String.Count(); j++)
				FilterList[i]->String[j].Free_String();
			FilterList[i]->String.Clear();
			FilterList[i]->Name.Free_String();
			delete FilterList[i];
		}
		FilterList.Clear();
		char line[1024];
		TextFilterStruct *filter = NULL;
		while (!feof(confFile) && fgets(line,sizeof(line) -1,confFile)) {
			for (unsigned int i = strlen(line) -1; i >= 0; i--) { // Remove the spaces and CRLF at the end
				if (line[i] == ' ' || line[i] == '\n') line[i] = 0;
				else break;
			}
			if (strlen(line) > 2 && line[0] != ';') {
				if (line[0] == '[' && line[strlen(line) -1] == ']') // New section and check the name length
				{
					if (filter != NULL) // Exist section, add to list
					{
						if (filter->Type == NULL || filter->String.Count() == 0 || filter->CompareType == TYPE_NONE) // Invalid settings
						{
							if (filter->Type == NULL)
								Console::Out("Message type is missing in filter \"%s\".\n",filter->Name.Get_Buffer());
							if (filter->String.Count() == 0)
								Console::Out("\"String\" is missing in filter \"%s\".\n",filter->Name.Get_Buffer());
							if (filter->CompareType == TYPE_NONE)
								Console::Out("Comparsion Type is missing in filter \"%s\".\n",filter->Name.Get_Buffer());
							Console::Out("Filter \"%s\" is disabled because required options are missing.\n",filter->Name.Get_Buffer());
							delete filter;
						}
						else // Valid settings
							FilterList.Add(filter);
						filter = NULL; // Reset pointer
					}
					if (filter == NULL)
						filter = new TextFilterStruct;
					filter->Enable = false;
					filter->Name = line +1;
					filter->Name.Resize(strlen(line) -1);
					filter->CompareType = TYPE_NONE;
					filter->Options = OPT_NONE;
					filter->Type = TYPE_NONE;
					for (int i = 0; i < filter->String.Count(); i++)
						filter->String[i].Free_String();
					filter->String.Clear();
				}
				else if (filter != NULL)
				{
					ncToken str(line);
					if (str.gettok(1,' ') == "Enable")
						filter->Enable = true;
					else if (str.numtok(' ') >= 2) // Make sure parameters are filled
					{
						if (str.gettok(1,' ') == "Option")
						{
							for (int i = 2; i <= str.numtok(' '); i++)
							{
								if (str.gettok(i,' ') == "LOG")
									filter->Options |= OPT_LOG;
								else if (str.gettok(i,' ') == "BHSHOOK")
									filter->Options |= OPT_BHSHOOK;
								else
									Console::Out("Unknown parameter \"%s\" for item \"%s\" in filter \"%s\".\n",str.gettok(i,' ').to_chr(),str.gettok(1,' ').to_chr(),filter->Name.Get_Buffer());
							}
						}
						else if (str.gettok(1,' ') == "Type")
						{
							for (int i = 2; i <= str.numtok(' '); i++)
							{
								if (str.gettok(i,' ') == "ALL")
									filter->Type |= MSG_ALL;
								else if (str.gettok(i,' ') == "TEAM")
									filter->Type |= MSG_TEAM;
								else
									Console::Out("Unknown parameter \"%s\" for item \"%s\" in filter \"%s\".\n",str.gettok(i,' ').to_chr(),str.gettok(1,' ').to_chr(),filter->Name.Get_Buffer());
							}
						}
						else if (str.gettok(1,' ') == "String")
						{
							if ((strlen(str.to_chr()) -7) <= 0)
								Console::Out("Warning - Empty string parameter in filter \"%s\".\n",filter->Name.Get_Buffer());
							else
							{
								wchar_t *tmpStr = new wchar_t[strlen(line) -6];
								mbstowcs(tmpStr,line +7,strlen(line) -7);
								tmpStr[strlen(line) -7] = '\0';
								ncWideString String;
								String = tmpStr;
								filter->String.Add(String);
								String.Free_String();
								delete [] tmpStr;
							}
						}
						else if (str.gettok(1,' ') == "Compare")
						{
							if (str.gettok(2,' ') == "NORM")
								filter->CompareType = TYPE_NORM;
							else if (str.gettok(2,' ') == "WILDCARD")
								filter->CompareType = TYPE_WILDCARD;
							else if (str.gettok(2,' ') == "REGEX")
								filter->CompareType = TYPE_REGEX;
							else
								Console::Out("Unknown compare type \"%s\" in filter \"%s\".\n",str.gettok(2,' ').to_chr(),filter->Name.Get_Buffer());
						}
					}
				}
			}
		}
		if (filter != NULL)
		{
			if (filter->Type == NULL || filter->String.Count() == 0 || filter->CompareType == TYPE_NONE) // Invalid settings
			{
				if (filter->Type == NULL)
					Console::Out("Message type is missing in filter \"%s\".\n",filter->Name.Get_Buffer());
				if (filter->String.Count() == 0)
					Console::Out("String is missing in filter \"%s\".\n",filter->Name.Get_Buffer());
				if (filter->CompareType == TYPE_NONE)
					Console::Out("Comparsion Type is missing in filter \"%s\".\n",filter->Name.Get_Buffer());
				Console::Out("Filter \"%s\" is disabled because required options are missing.\n",filter->Name.Get_Buffer());
				delete filter;
			}
			else // Valid settings
				FilterList.Add(filter);
			filter = NULL;
		}
#ifdef __DEV__
		const char *CompareName[] = { "Normal", "Wildcards", "Regular Expression" };
		const char *TypeName[] = { "All", "Team", "All and Team" };
		const char *OptionName[] = { "None", "Log", "BHS ChatHook", "Log and BHS ChatHook" };
		for (int i = 0; i < FilterList.Count(); i++)
		{
			Console::Out("[%s]\n\tEnable: %s\n\tCompare: %s\n\tType: %s\n\tOption: %s\n\tString list:\n",
				FilterList[i]->Name.Get_Buffer(), 
				FilterList[i]->Enable == true ? "Yes" : "No",
				CompareName[FilterList[i]->CompareType -1],
				TypeName[FilterList[i]->Type -1],
				OptionName[FilterList[i]->Options]
			);
			for (int j = 0; j < FilterList[i]->String.Count(); j++)
				Console::Out("\t\t[%d] %S\n",j +1,FilterList[i]->String[j].Get_Buffer());
		}
#endif
#ifndef __DEV__
	}
#endif
}

int __fastcall wwildcmp(const wchar_t *wild, const wchar_t *string) {
	register const wchar_t *cp = NULL, *mp = NULL;
	while ((*string) && (*wild != '*')) {
		if ((*wild != *string) && (*wild != '?')) return 0;
		wild++;
		string++;
	}
	while (*string) {
		if (*wild == '*') {
			if (!*++wild) return 1;
			mp = wild;
			cp = string+1;
		}
		else if ((*wild == *string) || (*wild == '?')) {
			wild++;
			string++;
		}
		else {
			wild = mp;
			string = cp++;
		}
	}
	while (*wild == '*') wild++;
	return !*wild;
}

Init_Class::Init_Class()
{
	if (!Init_Hooks())
	{
		MessageBox(0,"Failed to load Hooks.dll. TextFilter.dll has been disabled.","FATAL ERROR",MB_OK);
		return;
	}
	if (Get_Hooks_Version() < MINIMUM_HOOKS_VERSION)
	{
		char msg[512];
		sprintf(msg,"Error - TextFilter.dll is incompatible with Hooks.dll version below %s. Current Hooks.dll version is %.2f, please upgrade.",MINIMUM_HOOKS_VERSION,Get_Hooks_Version());
		MessageBox(0,msg,"Error",MB_OK);
		return;
	}
	ReloadTextFilter = NULL;
	Mute = NULL;
	Unmute = NULL;
	RegisterFDSStartUpHook(Init_Class::Init_Hook);
}
Init_Class::~Init_Class()
{
	for (int i = 0; i < FilterList.Count(); i++)
	{
		for (int j = 0; j < FilterList[i]->String.Count(); j++)
			FilterList[i]->String[j].Free_String();
		FilterList[i]->String.Clear();
		FilterList[i]->Name.Free_String();
		delete FilterList[i];
	}
	FilterList.Clear();
	for (int i = 0; i < MuteList.Count(); i++)
		MuteList[i].Free_String();
	MuteList.Clear();
	if (ReloadTextFilter != NULL)
		delete ReloadTextFilter;
	if (Mute != NULL)
		delete Mute;
	if (Unmute != NULL)
		delete Unmute;

#ifdef __DEV__
	m_dumpMemoryReport("memleak_textfltr.log",true);
#endif
}
void Init_Class::Init_Hook()
{
	/* Install hooks */
	RegisterChatHook(Chat_Hook);
	RegisterLoadLevelHook(Load_Config);
	RegisterRadioHook(Radio_Hook);

	/* Console commands */
	ReloadTextFilter = new ReloadTextFilterConsoleCommand;
	Mute = new MuteConsoleCommand;
	Unmute = new UnmuteConsoleCommand;

	Console::Out("TextFilter.dll %s by Adad - Built on %s %s\n",VERSION_NAME,__DATE__,__TIME__);
}
Init_Class InitClass;

void Console::In(const char *msg, ...) {
	if (!msg || !*msg) return;
	char buf[256];
	va_list args;
	va_start(args,msg);
	_vsnprintf(buf,255,msg,args);
	va_end(args);
	typedef void (*_ConsoleIn)(const char *);
	_ConsoleIn ConsoleIn = (_ConsoleIn)0x428960;
	ConsoleIn(buf);
}
void Console::Out(const char *msg, ...) {
	if (!msg || !*msg) return;
	va_list args;
	va_start(args,msg);
	int size = _vscprintf(msg,args);
	char *tmp = new char[size +1];
	vsprintf(tmp,msg,args);
	typedef void (*_ConsoleOut)(const char *);
	_ConsoleOut ConsoleOut = (_ConsoleOut)0x428CD0;
	ConsoleOut(tmp);
	delete [] tmp;
	va_end(args);
}
