#ifndef FDS_WEAPON
#define FDS_WEAPON

#include "fds.h"

class WeaponDefinitionClass : public DefinitionClass {
public:
	int Style; // 0x1C
	StringClass Model; // 0x20
	StringClass IdleAnim; // 0x24
	StringClass FireAnim; // 0x28
	StringClass BackModel; // 0x2C
	float SwitchTime; // 0x30
	FloatDataSafeClass ReloadTime; // 0x34
	float KeyNumber; // 0x38
	bool CanSnipe; // 0x3C
	bool CanRecieveGenericCnCAmmo; // 0x3D
	float Rating; // 0x40
	int EjectPhysDefID; // 0x44
	int MuzzleFlashPhysDefID; // 0x48
	StringClass FirstPersonModel; // 0x4C
	Vector3 FirstPersonOffset; // 0x50
	int RecoilImpulse; // 0x5C
	StringClass HUDIconTextureName; // 0x60
	int ReloadSoundDefID; // 0x64
	int EmptySoundDefID; // 0x68
	int PrimaryAmmoDefID; // 0x6C
	int SecondaryAmmoDefID; // 0x70
	IntDataSafeClass ClipSize; // 0x74
	float RecoilTime; // 0x78
	float RecoilScale; // 0x7C
	bool AGiveWeaponsWeapon; // 0x80
	IntDataSafeClass MaxInventoryRounds; // 0x84
	int IconNameID; // 0x88
	StringClass IconTextureName; // 0x8C
	RectClass IconTextureUV; // 0x90
	Vector2 IconTextureOffset; // 0xA4
	StringClass HumanFiringAnimation; // 0xA8
	~WeaponDefinitionClass();
	PersistFactoryClass &Get_Factory();
	bool Save(ChunkSaveClass &csave);
	bool Load(ChunkLoadClass &cload);
	unsigned long Get_Class_ID();
	PersistClass *Create();
};

class AmmoDefinitionClass : public DefinitionClass {
public:
	StringClass W3D;
	StringClass Model;
	IntDataSafeClass Warhead;
	FloatDataSafeClass Damage;
	FloatDataSafeClass Range;
	FloatDataSafeClass Velocity;
	float Gravity;
	float Elasticity;
	float RateOfFire;
	float SprayAngle;
	IntDataSafeClass SprayCount;
	StringClass TrailEmitterName;
	float AcquireTime;
	float BurstDelayTime;
	IntDataSafeClass BurstMax;
	int SoftPierceLimit;
	float TurnRate;
	bool TimeActivated;
	bool TerrainActivated;
	bool IsTracking;
	FloatDataSafeClass EffectiveRange;
	int ExplosionDefID;
	int RandomTrackingScale;
	bool DisplayLaser;
	FloatDataSafeClass ChargeTime;
	int ContinuousSoundDefID;
	int FireSoundDefID;
	StringClass ContinuousEmitterName;
	int MaxBounces;
	int SprayBulletCost;
	IntDataSafeClass AmmoType;
	float C4TriggerTime1;
	float C4TriggerTime2;
	float C4TriggerTime3;
	float C4TriggerRange1;
	float C4TriggerRange2;
	float C4TriggerRange3;
	int C4TimingSound1ID;
	int C4TimingSound2ID;
	int C4TimingSound3ID;
	float AliasedSpeed;
	int HitterType;
	int BeaconObject;
	bool BeamEnabled;
	Vector3 BeamColor;
	float BeamTime;
	float BeamWidth;
	bool BeamEndCaps;
	StringClass BeamTexture;
	bool BeamSubdivisionEnabled;
	float BeamSubdivisionScale;
	bool BeamSubdivisionFrozen;
	int IconNameID;
	StringClass IconTextureName;
	RectClass IconTextureUV;
	Vector2 IconOffset;
	int GrenadeSafetyTime;
	~AmmoDefinitionClass();
	PersistFactoryClass &Get_Factory();
	bool Save(ChunkSaveClass &csave);
	bool Load(ChunkLoadClass &cload);
	unsigned long Get_Class_ID();
	PersistClass *Create();
};

class RenderObjClass;
class MuzzleFlashClass {
public:
	int MuzzleBone1;
	int MuzzleBone2;
	int unk1;
	RenderObjClass *MuzzleRenderer;
	bool unk2;
	bool unk3;
};

class AudibleSoundClass;
class ParticleEmitterClass;
class WeaponClass {
public:
	WeaponDefinitionClass *WeaponDef;
	ReferencerClass Owner;
	RenderObjClass *ModelRenderer;
	int DetonationMode;
	AmmoDefinitionClass *AmmoDef1;
	AmmoDefinitionClass *AmmoDef2;
	IntDataSafeClass LoadedBullets; // 0x24
	IntDataSafeClass InventoryBullets; // 0x28
	FloatDataSafeClass Time; // 0x2C
	IntDataSafeClass FireCount; // 0x30
	float Speed; // 0x34
	bool IsOwned; // 0x38
	unsigned int State; // 0x3C
	float StateValue; // 0x40
	bool Firing; // 0x44
	bool PrimaryUnk; // 0x45
	bool SecondaryUnk; // 0x46
	bool PrimaryTriggered; // 0x47
	bool SecondaryTriggered; // 0x48
	int Muzzle1; // 0x4C
	bool unk1; // 0x50
	bool CanFire; // 0x51
	float FlashTime; // 0x54
	int Muzzle2; // 0x58
	int unk2; // 0x5C
	int StateVal; // 0x60
	Vector3 Position;
	ReferencerClass Target;
	SimpleVecClass<ParticleEmitterClass*> Emitters;
	AudibleSoundClass *ContinuousSound;
	AudibleSoundClass *FiringSound;
	int CurrentFireSoundDefID;
	MuzzleFlashClass Muzzle;
	WeaponClass();
};

class WeaponBagClass {
public:
	ArmedGameObj *Owner;
	DynamicVectorClass<WeaponClass *> Vector;
	int current;
	bool flag1;
	bool flag2;
};

class ExplosionDefinitionClass : public DefinitionClass {
public:
	int NextID;
	int TwiddlerID;
	float DamageRadius;
	float DamageStrength;
	int Warhead;
	bool DamageIsScaled;
	StringClass DecalFilename;
	float DecalSize;
	bool AnimatedExplosion;
	float CameraShakeIntensity;
	float CameraShakeRadius;
	float CameraShakeDuration;
	~ExplosionDefinitionClass();
	PersistFactoryClass &Get_Factory();
	bool Save(ChunkSaveClass &csave);
	bool Load(ChunkLoadClass &cload);
	unsigned long Get_Class_ID();
	PersistClass *Create();
};


class BeaconGameObjDef : public SimpleGameObjDef {
public:
	~BeaconGameObjDef();
	void On_Post_Load();
	PersistFactoryClass &Get_Factory();
	bool Save(ChunkSaveClass &csave);
	bool Load(ChunkLoadClass &cload);
	unsigned long Get_Class_ID();
	PersistClass *Create();
	float BroadcastToAllTime;
	float ArmTime;
	float DisarmTime;
	float PreDetonateCinematicDelay;
	float DetonateTime;
	float PostDetonateTime;
	int ArmedSoundDefID;
	int DisarmingTextID;
	int DisarmedTextID;
	int ArmingTextID;
	int ArmingInterruptedTextID;
	int DisarmingInterruptedTextID;
	int PreDetonateCinematicObj;
	int PostDetonateCinematicObj;
	int ExplosionObj;
	bool IsNuke;
	StringClass ArmingAnimationName;
};

class BeaconGameObj : public SimpleGameObj {
public:
	~BeaconGameObj();
	PersistFactoryClass &Get_Factory();
	bool Save(ChunkSaveClass &csave);
	bool Load(ChunkLoadClass &cload);
	void Init();
	void Get_Information(StringClass &str);
	void Completely_Damaged(const OffenseObjectClass &offense);
	BeaconGameObj *As_BeaconGameObj();
	SoldierGameObj *Get_Owner();
	ReferencerClass Owner;
	int State;
	float ArmTime;
	float PreDetonateCinematicDelay;
	float DetonateTime;
	float BroadcastToAllTime;
	AudibleSoundClass *ArmedSound;
	AudibleSoundClass *CurrentMessageSound;
	bool PreDetonateCinematicActive;
	WeaponDefinitionClass *WeaponDef;
	ReferencerClass CinematicObj;
	PlayerDataClass *Player;
};

class C4GameObjDef : public SimpleGameObjDef {
public:
	~C4GameObjDef();
	void On_Post_Load();
	PersistFactoryClass &Get_Factory();
	bool Save(ChunkSaveClass &csave);
	bool Load(ChunkLoadClass &cload);
	unsigned long Get_Class_ID();
	PersistClass *Create();
	float ThrowVelocity;
};

class C4GameObj : public SimpleGameObj {
public:
	~C4GameObj();
	PersistFactoryClass &Get_Factory();
	bool Save(ChunkSaveClass &csave);
	bool Load(ChunkLoadClass &cload);
	void Init();
	void Think();
	void Post_Think();
	void Get_Information(StringClass &str);
	void Completely_Damaged(const OffenseObjectClass &offense);
	C4GameObj *As_C4GameObj();
	void Export_Rare(BitStreamClass &BitStream);
	void Import_Rare(BitStreamClass &BitStream);
	int Collision_Occurred(const CollisionEventClass &collide);
	void Defuse();
	void Detonate();
	int Maintain_C4_Limit(int Team);
	float TriggerTime;
	ReferencerClass Owner;
	PlayerDataClass *Player;
	AmmoDefinitionClass *AmmoDef;
	int DetonationMode;
	bool unk1;
	bool unk2;
	ReferencerClass Attached;
	Vector3 AttachLocation;
	int AttachBoneIndex; // 0x84
	PhysClass *Physics; // 0x88
 	bool IsAttachedToMCT; // 0x8C
	float Time;
};

const char *Get_GameObj_Def_Weapon(GameObject *obj);
AmmoDefinitionClass *GetWeapAmmoDef(WeaponClass *wc,bool PrimaryFire);
AmmoDefinitionClass *Get_Current_Weapon_Ammo_Definition(GameObject *obj,bool PrimaryFire);
const char *Get_Current_Weapon(GameObject *obj);
int Total_Beacons(GameObject *obj);

#endif
