#include "scripts.h"
#include "fds_common.h"
#include "fds_thread.h"
#include "fds_string.h"
#include "fds_vector.h"
#include "fds_io.h"
#include "fds_def.h"
#include "fds_obj.h"

bool NAKED DamageableGameObj::Is_Enemy(GameObject *) THUNK(0x6D90D0)

void NAKED DefenseObjectClass::Set_Max_Health(float) THUNK(0x6910C0)
void NAKED DefenseObjectClass::Set_Max_Shield_Strength(float) THUNK(0x692980)

void NAKED PhysicalGameObj::Set_Transform(Matrix3D *) THUNK(0x6A5790)
Matrix3D NAKED *PhysicalGameObj::Get_Transform() THUNK(0x6A57B0)

ArmedGameObjDef *ArmedGameObj::Get_Definition() {
	return (ArmedGameObjDef *)this->definition;
}

void NAKED PowerUpGameObj::Grant(GameObject *) THUNK(0x6F1100)

void NAKED ScriptableGameObj::Add_Observer(GameObjObserverClass *) THUNK(0x6B6510)
void NAKED ScriptableGameObj::Remove_Observer(GameObjObserverClass *) THUNK(0x6B6600)

RefineryGameObjDef *RefineryGameObj::Get_Definition() {
	return (RefineryGameObjDef *)this->definition;
}
void NAKED RefineryGameObj::On_Harvester_Docked() THUNK(0x7433A0)
void NAKED RefineryGameObj::Set_Harvester_Vehicle(VehicleGameObj *) THUNK(0x743160)
GameObject NAKED *RefineryGameObj::Get_Harvester_Vehicle() THUNK(0x743350)

void NAKED SoldierGameObj::Re_Init(SoldierGameObjDef &) THUNK(0x6C6CB0)
void NAKED SoldierGameObj::Give_All_Weapons() THUNK(0x6CDE80)
void NAKED SoldierGameObj::Toggle_Fly_Mode() THUNK(0x6CF520)

int &VehicleFactoryGameObj::MaxVehiclesPerTeam = *(int *)0x8127F8;
int NAKED VehicleFactoryGameObj::Get_Team_Vehicle_Count() THUNK(0x6ED620)
void NAKED VehicleFactoryGameObj::Request_Vehicle(int, float, GameObject *) THUNK(0x6ED760)

SoldierGameObj NAKED *VehicleGameObj::Get_Driver() THUNK(0x67C110)

void NAKED HarvesterClass::Go_Harvest() THUNK(0x7694C0)

int &SpawnManager::Total_Spwaner = *(int *)0x8564B8;
DynamicVectorClass<SpawnerClass *> &SpawnManager::SpawnerList = *(DynamicVectorClass<SpawnerClass *> *)0x8564A8;

ScriptableGameObj *As_ScriptableGameObj(GameObject *obj) {
	if (!Commands->Get_ID(obj) || !obj)	return 0;
	return ((BaseGameObj *)obj)->As_ScriptableGameObj();
}

PhysicalGameObj *As_PhysicalGameObj(GameObject *obj) {
	if (!Commands->Get_ID(obj) || !obj)	return 0;
	return ((BaseGameObj *)obj)->As_PhysicalGameObj();
}

CinematicGameObj *As_CinematicGameObj(GameObject *obj) {
	if (!Commands->Get_ID(obj) || !obj)	return 0;
	PhysicalGameObj *o = As_PhysicalGameObj(obj);
	if (!o) return 0;
	return o->As_CinematicGameObj();
}

VehicleGameObj *As_VehicleGameObj(GameObject *obj) {
	if (!Commands->Get_ID(obj) || !obj)	return 0;
	return ((BaseGameObj *)obj)->As_VehicleGameObj();
}

SmartGameObj *As_SmartGameObj(GameObject *obj) {
	if (!Commands->Get_ID(obj) || !obj)	return 0;
	return ((BaseGameObj *)obj)->As_SmartGameObj();
}

DamageableGameObj *As_DamageableGameObj(GameObject *obj) {
	if (!Commands->Get_ID(obj) || !obj)	return 0;
	ScriptableGameObj *o = As_ScriptableGameObj(obj);
	if (!o) return 0;
	return o->As_DamageableGameObj();
}

SoldierGameObj *As_SoldierGameObj(GameObject *obj) {
	if (!Commands->Get_ID(obj) || !obj)	return 0;
	ScriptableGameObj *o = As_ScriptableGameObj(obj);
	if (!o) return 0;
	return o->As_SoldierGameObj();
}

ScriptZoneGameObj *As_ScriptZoneGameObj(GameObject *obj) {
	if (!Commands->Get_ID(obj) || !obj)	return 0;
	ScriptableGameObj *o = As_ScriptableGameObj(obj);
	if (!o) return 0;
	return o->As_ScriptZoneGameObj();
}

BuildingGameObj *As_BuildingGameObj(GameObject *obj) {
	if (!Commands->Get_ID(obj) || !obj)	return 0;
	ScriptableGameObj *o = As_ScriptableGameObj(obj);
	if (!o) return 0;
	return o->As_BuildingGameObj();
}

PowerUpGameObj *As_PowerUpGameObj(GameObject *obj) {
	if (!Commands->Get_ID(obj) || !obj)	return 0;
	PhysicalGameObj *o = As_PhysicalGameObj(obj);
	if (!o) return 0;
	return o->As_PowerUpGameObj();
}

C4GameObj *As_C4GameObj(GameObject *obj) {
	if (!Commands->Get_ID(obj) || !obj)	return 0;
	PhysicalGameObj *o = As_PhysicalGameObj(obj);
	if (!o) return 0;
	return o->As_C4GameObj();
}

BeaconGameObj *As_BeaconGameObj(GameObject *obj) {
	if (!Commands->Get_ID(obj) || !obj)	return 0;
	PhysicalGameObj *o = As_PhysicalGameObj(obj);
	if (!o) return 0;
	return o->As_BeaconGameObj();
}

ArmedGameObj *As_ArmedGameObj(GameObject *obj) {
	if (!Commands->Get_ID(obj) || !obj)	return 0;
	PhysicalGameObj *o = As_PhysicalGameObj(obj);
	if (!o) return 0;
	return o->As_ArmedGameObj();
}

SimpleGameObj *As_SimpleGameObj(GameObject *obj) {
	if (!Commands->Get_ID(obj) || !obj)	return 0;
	PhysicalGameObj *o = As_PhysicalGameObj(obj);
	if (!o) return 0;
	return o->As_SimpleGameObj();
}

//GameObject *As_PowerPlantGameObj(GameObject *obj) {
//	if (!Commands->Get_ID(obj) || !obj)	return 0;
//	GameObject *o2 = As_BuildingGameObj(obj);
//	if (!o2) return 0;
//	_asm {
//		mov ecx,o2
//		mov ebx,[ecx]
//		mov eax,[ebx+0x70]
//		call eax
//	}
//}
//
//GameObject *As_SoldierFactoryGameObj(GameObject *obj) {
//	if (!Commands->Get_ID(obj) || !obj) return 0;
//	GameObject *o2 = As_BuildingGameObj(obj);
//	if (!o2) return 0;
//	_asm {
//		mov ecx,o2
//		mov ebx,[ecx]
//		mov eax,[ebx+0x74]
//		call eax
//	}
//}

VehicleFactoryGameObj *As_VehicleFactoryGameObj(GameObject *obj) {
	if (!Commands->Get_ID(obj) || !obj)	return 0;
	BuildingGameObj *o = As_BuildingGameObj(obj);
	if (!o) return 0;
	return o->As_VehicleFactoryGameObj();
}

AirStripGameObj *As_AirstripGameObj(GameObject *obj) {
	if (!Commands->Get_ID(obj) || !obj) return 0;
	BuildingGameObj *o = As_BuildingGameObj(obj);
	if (!o) return 0;
	return o->As_AirStripGameObj();
}

WarFactoryGameObj *As_WarFactoryGameObj(GameObject *obj) {
	if (!Commands->Get_ID(obj) || !obj)	return 0;
	BuildingGameObj *o = As_BuildingGameObj(obj);
	if (!o) return 0;
	return o->As_WarFactoryGameObj();
}

RefineryGameObj *As_RefineryGameObj(GameObject *obj) {
	if (!Commands->Get_ID(obj) || !obj)	return 0;
	BuildingGameObj *o = As_BuildingGameObj(obj);
	if (!o) return 0;
	return o->As_RefineryGameObj();
}

ComCenterGameObj *As_ComCenterGameObj(GameObject *obj) {
	if (!Commands->Get_ID(obj) || !obj)	return 0;
	BuildingGameObj *o = As_BuildingGameObj(obj);
	if (!o) return 0;
	return o->As_ComCenterGameObj();
}

RepairBayGameObj *As_RepairBayGameObj(GameObject *obj) {
	if (!Commands->Get_ID(obj) || !obj)	return 0;
	BuildingGameObj *o = As_BuildingGameObj(obj);
	if (!o) return 0;
	return o->As_RepairBayGameObj();
}
