#include "scripts.h"
#include "fds_common.h"
#include "fds_thread.h"
#include "fds_string.h"
#include "fds_vector.h"
#include "fds_io.h"
#include "fds_def.h"

DefinitionClass NAKED *DefinitionMgrClass::Find_Definition(unsigned long, bool) THUNK(0x526000)
DefinitionClass NAKED *DefinitionMgrClass::Find_Named_Definition(const char *, bool unk) THUNK(0x526100)
DefinitionClass NAKED *DefinitionMgrClass::Find_Typed_Definition(const char *, unsigned long, bool) THUNK(0x526180)
DefinitionClass NAKED *DefinitionMgrClass::Get_First(unsigned long, int) THUNK(0x526540)
DefinitionClass NAKED *DefinitionMgrClass::Get_Next(DefinitionClass *, unsigned long, int) THUNK(0x5265B0)
DefinitionClass NAKED *DefinitionMgrClass::Get_Next(DefinitionClass *) THUNK(0x526620)

TeamPurchaseSettingsDefClass NAKED *TeamPurchaseSettingsDefClass::Get_Definition(unsigned long) THUNK(0x6F3430)
PurchaseSettingsDefClass NAKED *PurchaseSettingsDefClass::Find_Definition(unsigned long, unsigned long) THUNK(0x6F2BD0)

bool NAKED Set_Safe_Data_Int_Ref(void *, int &) THUNK(0x414350)
bool NAKED Set_Safe_Data_Float_Ref(void *, float &) THUNK(0x694830)
bool NAKED Set_Safe_Data_Uint_Ref(void *, unsigned int &) THUNK(0x695AA0)

float NAKED FloatDataSafeClass::Get() THUNK(0x413510)
bool FloatDataSafeClass::Set(float &data) {
	return Set_Safe_Data_Float_Ref(Data,data);
}

int NAKED IntDataSafeClass::Get() THUNK(0x408280)
bool IntDataSafeClass::Set(int &data) {
	return Set_Safe_Data_Int_Ref(Data,data);
}

unsigned int NAKED UIntDataSafeClass::Get() THUNK(0x408280)
bool UIntDataSafeClass::Set(unsigned int &data) {
	return Set_Safe_Data_Uint_Ref(Data,data);
}

void NAKED ReferencerClass::__as(const ScriptableGameObj *) THUNK(0x7080B0)

const char NAKED *ArmorWarheadManager::Get_Warhead_Name(int) THUNK(0x687080)
float NAKED ArmorWarheadManager::Get_Damage_Multiplier(unsigned int, unsigned int) THUNK(0x687090)

DefinitionClass *Get_Definition(GameObject *obj) {
	if (!Commands->Get_ID(obj) || !obj) return 0;
	return As_ScriptableGameObj(obj)->definition;
}

bool Is_Valid_Preset(const char *name) {
	if (DefinitionMgrClass::Find_Named_Definition(name,1)) return true;
	return false;
}
