#pragma once

//#define __DEV__
#define VERSION_NAME	"Beta 1"
#define MINIMUM_HOOKS_VERSION 1.03

#ifdef __DEV__
#include "mmgr.h"
#endif
#include "ncString.h"
#include "ncVector.h"

#define TYPE_NONE		0
#define TYPE_NORM		1
#define TYPE_WILDCARD	2
#define TYPE_REGEX		3

#define MSG_ALL			1
#define MSG_TEAM		2

#define OPT_NONE		0
#define OPT_LOG			1
#define OPT_BHSHOOK		2

struct TextFilterStruct {
	ncString Name;
	bool Enable;
	int CompareType;
	int Type;
	int Options;
	ncDynamicVector<ncWideString> String;
};

bool Chat_Hook(cCsTextObj *CsTextObj);
void Load_Config();
int __fastcall wwildcmp(const wchar_t *wild, const wchar_t *string);
extern ncDynamicVector<TextFilterStruct *> FilterList;;
extern ncDynamicVector<ncWideString> MuteList;

// Import load support
class Init_Class {
public:
	Init_Class();
	~Init_Class();
	static void Init_Hook();
};
extern Init_Class InitClass;

class Console {
public:
	static void In(const char *, ...);
	static void Out(const char *, ...);
};

class ReloadTextFilterConsoleCommand : public ConsoleFunctionClass {
	const char *Get_Name()
	{
		return "reloadtextfilter";
	}
	const char *Get_Alias()
	{
		return "rltxtfltr";
	}
	const char *Get_Help()
	{
		return "RELOADTEXTFILTER - Reload the text filter configuration from TextFilter.cfg.";
	}
	void Activate(char *text)
	{
		Load_Config();
	}
};
ReloadTextFilterConsoleCommand *ReloadTextFilter;

class MuteConsoleCommand : public ConsoleFunctionClass {
	const char *Get_Name()
	{
		return "mute";
	}
	const char *Get_Help()
	{
		return "MUTE <player id> - Block player from using chat(exclude private message) and radio commands.";
	}
	void Activate(char *text)
	{
		if (!text || !*text || !isdigit(text[0]))
		{
			Console::Out("Usage: mute <player id>\n");
			return;
		}
		cPlayer *pData = cPlayerManager::Find_Player(atoi(text));
		if (pData == NULL)
		{
			Console::Out("%d not found.\n",atoi(text));
			return;
		}
#ifndef __DEV__
		for (int i = 0; i < MuteList.Count(); i++)
		{
			if (MuteList[i] == pData->PlayerName.m_Buffer)
			{
				Console::Out("%S is already in mute list.\n",pData->PlayerName.m_Buffer);
				return;
			}
		}
#endif
		ncWideString Player;
		Player = pData->PlayerName.m_Buffer;
		MuteList.Add(Player);
		Player.Free_String();
		Console::In("ppage %d You're now being blocked from using chat(exclude private message) and radio commands.",pData->PlayerId);
	}
};
MuteConsoleCommand *Mute;

class UnmuteConsoleCommand : public ConsoleFunctionClass {
	const char *Get_Name()
	{
		return "unmute";
	}
	const char *Get_Help()
	{
		return "UNMUTE <player id/player name> - Remove player from the silence list.";
	}
	void Activate(char *text)
	{
		if (!text || !*text)
		{
			Console::Out("Usage: unmute <player id/player name>\n");
			return;
		}
		bool canDelete = false;
		wchar_t *Name = NULL;
		cPlayer *pData = NULL;
		if (isdigit(text[0]) && atoi(text) > 0 && atoi(text) < 128)
		{
			pData = cPlayerManager::Find_Player(atoi(text));
			if (pData)
				Name = pData->PlayerName.m_Buffer;
		}
		else
		{
			Name = new wchar_t[strlen(text) *2 +1];
			mbstowcs(Name,text,strlen(text) *2);
			canDelete = true;
			for (GenericSLNode<cPlayer> *pList = cPlayerManager::PlayerList->HeadNode; pList != NULL; pList = pList->NodeNext)
			{
				if (pList->NodeData != NULL && pList->NodeData->IsActive == true && !wcsicmp(pList->NodeData->PlayerName.m_Buffer,Name))
				{
					pData = pList->NodeData;
					break;
				}
			}
		}
		if (Name != NULL)
		{
			bool Found = false;
			for (int i = 0; i < MuteList.Count(); i++)
			{
				if (MuteList[i] == Name)
				{
					MuteList[i].Free_String();
					MuteList.Delete(i);
					if (pData)
						Console::In("ppage %d You're now removed from the mute list. You can use chat and radio commands now.",pData->PlayerId);
					Found = true;
					break;
				}
			}
			if (Found == false)
				Console::Out("%s not found in the mute list.\n",text);
			if (canDelete == true)
				delete [] Name;
		}
		else
			Console::Out("%s not found in the mute list.\n",text);
	}
};
UnmuteConsoleCommand *Unmute;
