#ifndef FDS_VECTOR
#define FDS_VECTOR

// Forwarder
class GenericMultiListClass;
class MultiListObjectClass;

class GenericNode {
	GenericNode* NextNode;
	GenericNode* PrevNode;
public:
	virtual ~GenericNode();
};

class GenericList {
	GenericNode FirstNode;
	GenericNode LastNode;
public:
	virtual ~GenericList();
};

template <class T> class List : GenericList {
public:
	virtual ~List();
};

template <typename T1,class T2> class IndexClass {
	struct NodeElement {
		int ID;
		T2 Data;
	};
	NodeElement* IndexTable;
	int IndexCount;
	int IndexSize;
	unsigned char IsSorted;
	NodeElement* Archive;
};

class MultiListNodeClass {
public:
	MultiListNodeClass* Prev;
	MultiListNodeClass* Next;
	MultiListNodeClass* NextList;
	MultiListObjectClass* Object;
	GenericMultiListClass* List;
};

class GenericMultiListClass {
public:
	MultiListNodeClass Head;
	MultiListObjectClass *Internal_Remove_List_Head();
	virtual ~GenericMultiListClass();
};

class MultiListObjectClass {
	MultiListNodeClass* ListNode;
public:
	virtual ~MultiListObjectClass();
};

template <class t> class MultiListClass : public GenericMultiListClass {
public:
	~MultiListClass();
};

template <class t> class RefMultiListClass : public GenericMultiListClass {
public:
	~RefMultiListClass();
};

class GenericMultiListIterator {
public:
	GenericMultiListClass* List;
	MultiListNodeClass* Node;
};

template <typename T> struct GenericSLNode {
	GenericSLNode *NodeNext;
	T *NodeData;
};

template <typename T> class SList {
public:
	GenericSLNode<T> *HeadNode;
	GenericSLNode<T> *TailNode;
	virtual ~SList()
	{
	}
	virtual bool Add_Head(T *data)
	{
		return false;
	}
	virtual bool Add_Head(SList<T> &list)
	{
		return false;
	}
	virtual bool Add_Tail(T *data)
	{
		return false;
	}
	virtual bool Add_Tail(SList<T> &list)
	{
		return false;
	}
	virtual T *Remove_Head()
	{
		return 0;
	}
	virtual T *Remove_Tail()
	{
		return 0;
	}
	virtual bool Remove(T *element)
	{
		return false;
	}
	virtual void Remove_All()
	{
	}
	virtual bool Insert_Before(T *newnode,T *oldnode)
	{
		return false;
	}
	virtual bool Insert_After(T *newnode,T *oldnode)
	{
		return false;
	}
	virtual bool Is_Empty()
	{
		return false;
	}
	virtual long Get_Count()
	{
		return 0;
	}
};

template <class T> class SimpleVecClass {
protected:
	T *Vector;
	int VectorMax;
public:
	SimpleVecClass(unsigned int size)
	{
		Vector = 0;
		VectorMax = 0;
		if (size > 0)
		{
			Resize(size);
		}
	}
	virtual bool Uninitialised_Grow(int newsize)
	{
		if ((newsize > 0) && (newsize > VectorMax))
		{
			delete Vector;
			Vector = new T[newsize*4];
			VectorMax = newsize;
		}
		return true;
	}
	SimpleVecClass(const SimpleVecClass<T> &cl)
	{
		VectorMax = cl.VectorMax;
		Vector = new T[VectorMax*4];
		memcpy(Vector,cl.Vector,VectorMax*4);
	}
	int Length()
	{
		return VectorMax;
	}
	T &operator[](int index)
	{
		return Vector[index];
	}
	virtual ~SimpleVecClass()
	{
		if (Vector)
		{
			delete Vector;
			Vector = 0;
			VectorMax = 0;
		}
	}
	virtual bool Resize(int newsize)
	{
		T *vec;
		if (VectorMax == newsize)
		{
			return true;
		}
		if (newsize > 0)
		{
			vec = new T[newsize*4];
			if (Vector)
			{
				int count;
				count = VectorMax;
				if (newsize < count)
				{
					count = newsize;
				}
				memcpy(vec,Vector,count*4);
				delete Vector;
				Vector = 0;
			}
			Vector = vec;
			VectorMax = newsize;
		}
		else
		{
			VectorMax = 0;
			if (Vector)
			{
				delete Vector;
				Vector = 0;
			}
		}
		return true;
	}
	SimpleVecClass &operator=(const SimpleVecClass<T> &cl)
	{
		if (Vector)
		{
			delete Vector;
		}
		VectorMax = cl.VectorMax;
		Vector = new T[VectorMax*4];
		memcpy(Vector,cl.Vector,VectorMax*4);
		return *this;
	}
};

template <class T> class SimpleDynVecClass : public SimpleVecClass<T> {
protected:
	int ActiveCount;
public:
	SimpleDynVecClass() : SimpleVecClass<T>(0)
	{
		ActiveCount = 0;
	}
	SimpleDynVecClass(int size) : SimpleVecClass<T>(size)
	{
		ActiveCount = size;
	}
	SimpleDynVecClass(const SimpleDynVecClass<T> &cl) : SimpleVecClass<T>(cl)
	{
		ActiveCount = cl.ActiveCount;
	}
	int Count()
	{
		return ActiveCount;
	}
	virtual ~SimpleDynVecClass()
	{
		if (Vector)
		{
			delete[] Vector;
			Vector = 0;
		}
	}
	virtual bool Resize(int newsize)
	{
		if (SimpleVecClass<T>::Resize(newsize))
		{
			if (VectorMax < ActiveCount)
			{
				ActiveCount = VectorMax;
			}
			return true;
		}
		return false;
	}
	int Add(T& data)
	{
		for (int i = 0;i < VectorMax;i++)
		{
			if (!Vector[i])
			{
				Vector[i] = data;
				return i;
			}
		}
		Resize(VectorMax+1);
		Vector[VectorMax-1] = data;
		ActiveCount++;
		return VectorMax-1;
	}
	void Clear(int position)
	{
		Vector[position] = 0;
	}
	void ClearAll()
	{
		memset(Vector,0,VectorMax*sizeof(T));
	}
	void Delete(int position)
	{
		if (position < (ActiveCount - 1))
		{
			int size = ((ActiveCount - position) * sizeof(T)) - sizeof(T);
			memmove(&Vector[position],&Vector[position+1],size);
		}
		ActiveCount--;
		Vector[ActiveCount] = 0;
	}
	void Delete_All()
	{
		ActiveCount = 0;
		VectorMax = 0;
		if (Vector)
		{
			delete[] Vector;
			Vector = 0;
		}
	}
	SimpleDynVecClass &operator=(const SimpleDynVecClass<T> &cl)
	{
		SimpleVecClass<T>::operator =(cl);
		ActiveCount = cl.ActiveCount;
		return *this;
	}
};

template <class T> class VectorClass {
protected:
	T *Vector;
	int VectorMax;
	bool IsValid;
	bool IsAllocated;
public:
	virtual ~VectorClass()
	{
		if (this->Vector) {
			delete [] Vector;
			Vector = 0;
		}
	}
	int Length()
	{
		return VectorMax;
	}
	T &operator[](int index)
	{
		return Vector[index];
	}
	virtual bool operator==(VectorClass<T> &vector)
	{
		return this->Vector == vector.Vector;
	}
	virtual bool Resize(int newsize,T *Array)
	{
		if (this->VectorMax == newsize)
			return false;
		if (newsize > 0)
		{
			T *vec = new T[newsize *4];
			if (this->Vector)
			{
				int count = this->VectorMax;
				if (newsize < count)
					count = newsize;
				memcpy(vec,Array,count*4);
				delete this->Vector;
				this->Vector = 0;
			}
			this->Vector = vec;
			this->VectorMax = newsize;
		}
		else
		{
			this->VectorMax = 0;
			if (this->Vector)
			{
				delete [] this->Vector;
				this->Vector = 0;
			}
		}
		return false;
	}
	virtual void Clear()
	{
		if (this->Vector) {
			delete [] Vector;
			Vector = 0;
		}
	}
	virtual int ID(T &object)
	{
		return 0;
	}
	virtual int ID(T *ptr)
	{
		return 0;
	}
};

template <class T> class DynamicVectorClass : public VectorClass<T> {
private:
	int ActiveCount;
	int GrowthStep;
public:
	void Reset_Active()
	{
		ActiveCount = 0;
	}
	int Count()
	{
		return ActiveCount;
	}
	virtual ~DynamicVectorClass()
	{
	}
	virtual bool Resize(int newsize,T *Array)
	{
		return false;
	}
	virtual void Clear()
	{
		if (Vector) {
			delete [] Vector;
			Vector = 0;
		}
	}
	virtual int ID(T &object)
	{
		return 0;
	}
	virtual int ID(T *ptr)
	{
		return 0;
	}
	bool Add(T& object)
	{
		if (ActiveCount >= VectorMax)
		{
			if ((IsAllocated || !VectorMax) && (GrowthStep > 0))
			{
				if (!Resize(GrowthStep + VectorMax,this->Vector))
				{
					return false;
				}
			}
			else
			{
				return false;
			}
		}
		this->ActiveCount = this->VectorMax;
		Vector[ActiveCount++] = object;
		return true;
	}
	bool Delete(int pos)
	{
		if (pos >= ActiveCount)
		{
			return false;
		}
		ActiveCount--;
		if (pos >= ActiveCount)
		{
			return true;
		}
		memmove(&Vector[pos],&Vector[pos+1],(ActiveCount - pos) * sizeof(T));
		return true;
	}
	bool Delete(T& object)
	{
		int pos = ID(object);
		if (pos != -1)
		{
			return Delete(pos);
		}
		return false;
	}
};

#ifndef WIN32
template <class T> class DataNode: public GenericNode {
public:
	T *Ref;
};
#endif

class RefCountClass {
public:
	long NumRefs;
#ifndef WIN32
	DataNode<RefCountClass*> Node;
	const char* RefFile;
	unsigned int RefLine;
#endif
	virtual void Delete_This()
	{
		delete this;
#ifdef DEBUG
		//log("[I] RefCountClass delete from 0x%08X",_ReturnAddress());
#endif
	}
	virtual ~RefCountClass()
	{
	}
	void Release_Ref()
	{
#ifdef WIN32
		if (!InterlockedDecrement(&NumRefs))
#else
		if (!--NumRefs)
#endif
		{
			Delete_This();
		}
	}
	void Add_Ref()
	{
#ifdef WIN32
		InterlockedIncrement(&NumRefs);
#else
		NumRefs++;
#endif
	}
};

template <class t> class ShareBufferClass : public RefCountClass {
	t* Array;
	int Count;
public:
	t *Get_Array()
	{
		return Array;
	}
	int Get_Count()
	{
		return Count;
	}
	t &Get_Element(int element)
	{
		return Array[element];
	}
	~ShareBufferClass();
};

template <class T> class EnlargeableBufferClass
{
	T* Buffer;
	unsigned int BufferSize;
public:
	EnlargeableBufferClass()
	{
		Buffer = 0;
		BufferSize = 0;
	}
	EnlargeableBufferClass(unsigned int size)
	{
		Buffer = new T[size];
		BufferSize = size;
	}
	~EnlargeableBufferClass()
	{
		delete[] Buffer;
	}
	T* ReplaceBuffer(T* newbuffer,unsigned int newsize)
	{
		T* temp = Buffer;
		Buffer = newBuffer;
		BufferSize = newsize;
		return temp;
	}
	T* GetBuffer()
	{
		return Buffer;
	}	
	unsigned int GetCurrentBufferSize()
	{
		return BufferSize;
	}
	T* Enlarge(unsigned int newsize)
	{
		if (newsize > BufferSize)
		{
			delete[] Buffer;
			Buffer = new T[newsize];
			BufferSize = newsize;
		}
		return Buffer;
	}
	T &operator[](int index)
	{
		return Buffer[index];
	}
};

#endif
