#ifndef FDS_THREAD
#define FDS_THREAD

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include "fds.h"

#ifdef WIN32
struct THREADNAME_INFO
{
	DWORD dwType; // must be 0x1000
	LPCSTR szName; // pointer to name (in user addr space)
	DWORD dwThreadID; // thread ID (-1=caller thread)
	DWORD dwFlags; // reserved for future use, must be zero
};

class CriticalSectionClass {
	unsigned int x;
public:
	void Lock();
	void Unlock()
	{
		x = 0;
	}
};

#else
class CriticalSectionClass {
	unsigned int x;
	unsigned int y;
public:
	void Lock()
	{
	}
	void Unlock()
	{
	}
};
#endif

#ifdef WIN32
void SetThreadName(DWORD dwThreadID, LPCSTR szThreadName);
#endif

#endif
