#ifndef FDS_PLAYER
#define FDS_PLAYER

// Forwarder
class DamageableGameObj;

class PlayerDataClass {
public:
#ifdef WIN32
	~PlayerDataClass();
#else
	virtual ~PlayerDataClass();
#endif
	virtual void Reset_Player(); // 0x0
	virtual void Set_Score(float score); // 0x4
	virtual void Increment_Score(float score); // 0x8
	virtual void Set_Money(float money); // 0xC
	virtual void Increment_Money(float money); // 0x10
	virtual bool Purchase_Item(int money); // 0x14
	virtual void Apply_Damage_Points(float points, DamageableGameObj *damager); // 0x18
	virtual void Apply_Death_Points(float points, DamageableGameObj *damager); // 0x1C
	FloatDataSafeClass Score; // 0x4
	FloatDataSafeClass Money; // 0x8
	ReferencerClass Owner; // 0xC
	float PunishTimer; // 0x1C
	float GameTime; // 0x20
	float SessionTime; // 0x24
	int EnemiesKilled; // 0x28
	int AlliesKilled; // 0x2C
	int ShotsFired; // 0x30
	int HeadShots; // 0x34
	int TorsoShots; // 0x38
	int ArmShots; // 0x3C
	int LegShots; // 0x40
	int CrotchShots; // 0x44
	float FinalHealth; // 0x48
	int PowerupsCollected; // 0x4C
	int VehiclesDestroyed; // 0x50
	float VehicleTime; // 0x54
	int KillsFromVehicle; // 0x58
	int Squishes; // 0x5C
	float CreditGrant; // 0x60
	int BuildingDestroyed; // 0x64
	int HeadHit; // 0x68
	int TorsoHit; // 0x6C
	int ArmHit; // 0x70
	int LegHit; // 0x74
	int CrotchHit; // 0x78
	int WeaponFired; // 0x7C
	SimpleDynVecClass<int> WeaponsFired; // 0x80
	SimpleDynVecClass<int> WeaponsFired2; // 0x90
};
class cPlayer : public PlayerDataClass, public NetworkObjectClass {
public:
	~cPlayer();
	void Reset_Player();
	void Set_Score(float score);
	void Increment_Score(float score);
	void Set_Money(float money);
	void Increment_Money(float money);
	unsigned int Get_Network_Class_ID();
	void Import_Creation(BitStreamClass &BitStream);
	void Import_Rare(BitStreamClass &BitStream);
	void Import_Occasional(BitStreamClass &BitStream);
	void Export_Creation(BitStreamClass &BitStream);
	void Export_Rare(BitStreamClass &BitStream);
	void Export_Occasional(BitStreamClass &BitStream);
	void Delete();
	void Set_Player_Type(int Type);
	Vector3 Get_Color();
	bool IsHuman; // 0x754
	WideStringClass PlayerName; // 0x758
	int PlayerId; // 0x75C
	IntDataSafeClass LadderPoints; // 0x760
	IntDataSafeClass Kills; // 0x764
	IntDataSafeClass Deaths; // 0x768
	IntDataSafeClass PlayerType; // 0x76C
	IntDataSafeClass Rung; // 0x770
	IntDataSafeClass WolRank; // 0x774
	short WolPoints; // 0x778
	int DamageScaleFactor; // 0x77C
	int Ping; // 0x780
	int JoinTime; // 0x784
	int TotalTime; // 0x788
	unsigned long IpAddress; // 0x78C
	int Fps; // 0x790
	unsigned long LastUpdateTimeMs; // 0x794
	int FastSortKey; // 0x798
	int NumWolGames; // 0x79C
	bool IsWaitingForIntermission; // 0x7A0
	int GameSpyAuthState; // 0x7A4
	unsigned long GameSpyAuthStateEntryTimeMs; // 0x7A8
	StringClass GameSpyChallengeString; // 0x7AC
	StringClass GameSpyHashId; // 0x7B0
	int GameSpyKickState; // 0x7B4
	unsigned long GameSpyKickStateEntryTimeMs; // 0x7B8
	bool IsInGame; // 0x7BC
	bool IsActive; // 0x7BD
	unsigned long WolClanId; // 0x7C0
};

class cPlayerManager {
public:
	static SList<cPlayer> *PlayerList;
	static cPlayer **Player_Array;
	static cPlayer *Find_Player(int ID);
	static cPlayer *Find_Player(const WideStringClass &name);
	static unsigned int Count();
	static void Reset_Players();
	static int Tally_Team_Size(int Team);
	static void Sort_Players(bool ByScore);
};

class cTeam : public NetworkObjectClass {
public:
	virtual ~cTeam();
	unsigned int Get_Network_Class_ID();
	void Import_Creation(BitStreamClass &BitStream);
	void Import_Rare(BitStreamClass &BitStream);
	void Import_Occasional(BitStreamClass &BitStream);
	void Export_Creation(BitStreamClass &BitStream);
	void Export_Rare(BitStreamClass &BitStream);
	void Export_Occasional(BitStreamClass &BitStream);
	void Export_Frequent(BitStreamClass &BitStream);
	void Delete();
	void Reset();
	float Tally_Money();
	WideStringClass TeamName; // 0x6B0
	int Kills; // 0x6B4
	int Deaths; // 0x6B8
	float Score; // 0x6BC
	int unk1; // 0x6C0
	int TeamId; // 0x6C4
};

class cTeamManager {
public:
	static SList<cTeam> *TeamList;
	static cTeam *Find_Team(int Team);
};

class VendorClass {
public:
	/* 0 -> "Purchase request granted."
	   1 -> "Transaction pending."
	   2 -> "You have insufficient funds for this purchase."
	   3 -> "The factory is not presently available."
	   4 -> "This item is not presently in stock." */
	typedef enum {
		Cost_Infantry = 0,
		Cost_Vehicle = 1,
		Free_Infantry = 2,
		Powerup = 3,
		Refill = 4,
		Secret_Infantry = 5,
	} Purchase_Type;
	static void Get_Merchandise_Information(GameObject *obj, int Type, int Item, int IsAlt, int &cost, unsigned long &preset);
	static int Purchase_Vehicle(BaseControllerClass *base, GameObject *obj, int cost, unsigned long preset);
	static int Purchase_Powerup(BaseControllerClass *base, GameObject *obj, int cost, unsigned long preset);
	static int Purchase_Character(BaseControllerClass *base, GameObject *obj, int cost, unsigned long preset);
	static int Purchase_Item(GameObject *obj, int PurchaseType, int ItemID, int unk, bool Respond) ;
	static int Grant_Supplies(GameObject *obj);
};

typedef struct {
	int Type; // 0x0
	ReferencerClass *unkt1; // 0x4
	bool unkt2; // 0x8
	int unkt3; // 0xC
	int unkt4; // 0x10
} TransitionCompletionDataStruct;

class TransitionDataClass {
public:
	typedef enum {
		LADDER_EXIT_TOP = 0,
		LADDER_EXIT_BOTTOM = 1,
		LADDER_ENTER_TOP = 2,
		LADDER_ENTER_BOTTOM = 3,
		LEGACY_VEHICLE_ENTER_0 = 4,
		LEGACY_VEHICLE_ENTER_1 = 5,
		LEGACY_VEHICLE_EXIT_0 = 6,
		LEGACY_VEHICLE_EXIT_1 = 7,
		VEHICLE_ENTER = 8,
		VEHICLE_EXIT = 9,
	} StyleType;
	int Type; // 0x0
	OBBoxClass Box; // 0x4 (0x3C)
	StringClass Animation; // 0x40
	Matrix3D Matrix; // 0x44
};

class TransitionInstanceClass {
public:
	bool Check(GameObject *obj, bool unk);
	void Start(GameObject *obj);
	void End(GameObject *obj, TransitionCompletionDataStruct *Complete);
	void Set_Parent_Transform(const Matrix3D &Transform);
	Matrix3D Transform; // 0x0 (0x30)
	OBBoxClass OBBox; // 0x30 (0x3C)
	ReferencerClass Target; // 0x6C (0x10)
	TransitionDataClass *Data; // 0x7C
	int LadderIndex; // 0x80
};

class TransitionManager {
public:
	static void Add(TransitionInstanceClass *Instance);
	static void Destroy(TransitionInstanceClass *Instance);
	static void Reset();
	static void Destroy_Pending();
	static void Check(GameObject *obj, bool unk);
	static void Build_Ladder_List(DynamicVectorClass<TransitionInstanceClass *> &Vector);
};

class CCDKeyAuth {
public:
	static const char *GenChallenge(int Length);
	static void AuthenticateUser(int ID, unsigned long IP, char *ChallengeStr, char *Hash);
};

const char *Get_Player_Name(GameObject *obj);
const char *Get_Player_Name_By_ID(int ID);
GameObject *Get_GameObj(int ID);
int Get_Player_ID(GameObject *obj);

#endif
