#ifndef FDS_NET
#define FDS_NET

// Forwarder
class BuildingGameObj;
class DamageableGameObj;
class VehicleGameObj;

typedef enum {
	ACCEPT = 0,
	FULL = 1, // "Connection to server refused: game is full"
	BADPASS = 2, // "Incorrect password"
	VERSION_MISMATCH = 3, // "Connection to server refused....Version mismatch"
	MSG1 = 4, // "Connection to server refused."
	MSG2 = 5, // "Connection to server refused."
} REFUSAL_CODE;

typedef enum {
	All = 0,
	Team = 1,
	Private = 2,
} TextMessageEnum;

struct Quaternion {
	float unk1;
	float unk2;
	float unk3;
	float unk4;
};

typedef void *UNK;

class cEncoderTypeEntry {
public:
	int unk1; // 0x0
	float unk2; // 0x4
	int unk3; // 0x8
	float unk4; // 0xC
	int unk5; // 0x10
	float unk6; // 0x14
	int length; // 0x18
	void Scale(double unk, unsigned long &buf);
	void Unscale(unsigned long buf);
};

class cEncoderList {
public:
	static cEncoderTypeEntry *Get_Encoder_Type_Entry(int Type);
	static bool IsCompressionEnabled;
};

//template <typename T, int unk> class ObjectPoolClass {
//public:
//	int unk1;
//	int unk2;
//	int unk3;
//	int unk4;
//	CriticalSectionClass Critical;
//};
template <typename T, int unk> class AutoPoolClass {
public:
	//void *operator new(unsigned int);
	//void *operator delete(void *);
};

class cBitPacker {
public:	
	virtual ~cBitPacker();
	cBitPacker();
	cBitPacker& operator=(const cBitPacker&);
	void Add_Bits(unsigned long, unsigned int);
	void Get_Bits(unsigned long &buf, unsigned int size);
	void Set_Bit_Write_Position(unsigned int);
	unsigned char Data[0x224]; // 0x0
	int BitWritePosition; // 0x228
	int BitReadPosition; // 0x22C
};

class BitStreamClass : public cBitPacker {
public:
	virtual ~BitStreamClass();
	BitStreamClass();
	BitStreamClass& operator=(const BitStreamClass&);
	void Add(bool value);
	void Get(bool &buf);
	void Add_Raw_Data(const char *, unsigned short);
	void Get_Raw_Data(char *, unsigned short, unsigned short);
	void Add_Terminated_String(char const *value, bool);
	void Get_Terminated_String(char *buf, unsigned short size, bool unk);
	void Add_Wide_Terminated_String(const wchar_t *value, bool);
	void Get_Wide_Terminated_String(wchar_t *buf, unsigned short size, bool unk);
	float Get_Compressed_Size_Bytes();
	const float Get_Compression_Pc();
	template<typename T> void Internal_Add(T buf, int encode_type) {
		if (cEncoderList::IsCompressionEnabled == 0 || encode_type == -1) {
			this->Add_Bits(buf,32);
			this->Size += 4;
		}
		else {
			cEncoderTypeEntry *encode = cEncoderList::Get_Encoder_Type_Entry(encode_type);
			encode->Scale(encode_type,*(unsigned long *)&buf);
			this->Add_Bits(buf,encode->length);
			this->Size += 4;
		}
	}
	template<typename T> void Internal_Get(T &buf, int encode_type) {
		if (cEncoderList::IsCompressionEnabled == 0 || encode_type == -1) this->Get_Bits(*(unsigned long *)&buf,32);
		else {
			cEncoderTypeEntry *encode = cEncoderList::Get_Encoder_Type_Entry(encode_type);
			this->Get_Bits(*(unsigned long *)&buf,encode->length);
			encode->Unscale(encode_type);
		}
	}
	int Size; // 0x230
};

class cPacket :
	public BitStreamClass, // Offset: 0x0 (0)
	public AutoPoolClass<cPacket,256> // Offset: 0x0 (0)
{
public:
	virtual ~cPacket();
	static cPacket& Create();
	cPacket& operator=(const cPacket&);
	void Add_Vector3(Vector3&);
	void Get_Vector3(Vector3&);
	void Add_Quaternion(Quaternion&);
	void Get_Quaternion(Quaternion&);
	void Set_Type(unsigned char);
	void Set_Id(int);
	void Set_Sender_Id(int);
	void Set_Send_Time();
	void Set_Num_Sends(int);
	void Init_Encoder();
	static void Construct_Full_Packet(cPacket&, cPacket&);
	static void Construct_App_Packet(cPacket&, cPacket&);
	sockaddr_in Sender; // 0x234
	unsigned char Type; // 0x244
	int Id; // 0x248
	int SenderId; // 0x24C
	unsigned long SendTime; // 0x250
	unsigned long FirstSendTime; // 0x254
	unsigned long ResendCount; // 0x258
	int NumSends; // 0x25C
};

struct Update {
	unsigned int LastUpdateTime;
	short UpdateRate;
	unsigned char HintCount;
};

enum DIRTY_BIT {
	DB_CREATION = 0x0F,
	DB_RARE = 7,
	DB_OCCASIONAL = 3,
	DB_FREQUENT = 1,
};

class NetworkObjectClass {
public:
	unsigned int NetworkID;
	Update UpdateData[128];
	char DirtyBits[128];
	unsigned int ImportStateCount;
	unsigned int LastClientsideUpdateTime;
	unsigned int CreationTime;
	unsigned int ClientUpdateCount;
	unsigned int unk2;
	bool DeletePending;
	unsigned char PacketType;
	unsigned int LastDamaged;
	unsigned int LastDamager;
	unsigned char FrequentUpdateExportSize;
	float CachedPriority;
	float CachedPriority2[128];
	bool UnreliableOverride;
	virtual ~NetworkObjectClass();
	virtual unsigned int Get_Network_Class_ID();
	virtual void Import_Creation(BitStreamClass &BitStream);
	virtual void Import_Rare(BitStreamClass &BitStream);
	virtual void Import_Occasional(BitStreamClass &BitStream);
	virtual void Import_Frequent(BitStreamClass &BitStream);
	virtual void Export_Creation(BitStreamClass &BitStream);
	virtual void Export_Rare(BitStreamClass &BitStream);
	virtual void Export_Occasional(BitStreamClass &BitStream);
	virtual void Export_Frequent(BitStreamClass &BitStream);
	virtual void Network_Think();
	virtual void Set_Delete_Pending();
	virtual void Delete() = 0;
	virtual void Set_Object_Dirty_Bit(DIRTY_BIT Bit, bool Set);
	virtual void Set_Object_Dirty_Bit(int Client_ID, DIRTY_BIT Bit, bool Set);
	virtual void Clear_Object_Dirty_Bits();
	virtual bool Get_Object_Dirty_Bit(int Client_ID,DIRTY_BIT Bit);
	virtual bool Get_Object_Dirty_Bits(int Client_ID);
	virtual bool Set_Object_Dirty_Bits(int Client_ID,unsigned char Bits);
	virtual bool Is_Client_Dirty(int Client_ID);
	virtual int Get_Vis_ID();
	virtual bool Get_World_Position(Vector3 &Position);
	virtual float Get_Filter_Distance();
	virtual bool Is_Tagged();
	virtual void Get_Description(StringClass &Description);
	virtual float Get_Cached_Priority();
};

class NetworkObjectMgrClass {
public:
	static DynamicVectorClass<NetworkObjectClass *> &ObjectList;
	static DynamicVectorClass<NetworkObjectClass *> &DeletePendingList;
};

class BaseControllerClass : public NetworkObjectClass {
public:
	float OperationTimeFactor; // 0x6B4
	int team; // 0x6B8
	DynamicVectorClass<GameObject *> BuildingList; // 0x6BC
	bool IsPowered; // 0x6D4
	bool CanGenerateSoldiers; // 0x6D5
	bool CanGenerateVehicles; // 0x6D6
	bool RadarEnabled; // 0x6D7
	bool BaseDestroyed; // 0x6D8
	bool BeaconDestroyedBase; // 0x6D9
	OBBoxClass BeaconZone; // 0x6DC
	unsigned int AnnouncementInterval;
	unsigned int AnnouncementUnknown;
	unsigned int AnnouncementUnknown2;
	unsigned int Unknown1;
	unsigned int Unknown2;
	~BaseControllerClass();
	void Set_Delete_Pending();
	void Delete();
	void Power_Base(bool Power);
	void Set_Can_Generate_Soldiers(bool CanGenerate);
	void Set_Can_Generate_Vehicles(bool CanGenerate);
	BuildingGameObj *Find_Building(unsigned int Type);
	static BaseControllerClass *Find_Base(int Team);
	void Destroy_Base();
	void Set_Beacon_Destroyed_Base(bool BeaconDestroyed);
	void Import_Occasional(BitStreamClass &BitStream);
	void Export_Occasional(BitStreamClass &BitStream);
	void Enable_Radar(bool Enable);
	VehicleGameObj *Get_Harvester_Vehicle();
};

class cNetEvent : public NetworkObjectClass {
public:
	virtual ~cNetEvent();
	virtual void Delete();
	virtual void Act() = 0;
	virtual void Import_Creation(BitStreamClass &);
	virtual void Export_Creation(BitStreamClass &);
};

class cBioEvent : public cNetEvent {
public:
	int ID; // 0x6B4
	WideStringClass PlayerName; // 0x6B8
	StringClass MapName; // 0x6BC
	//int Team; // 0x7BC
	//unsigned long WolClanId; // 0x7C0
	virtual ~cBioEvent();
	virtual unsigned int Get_Network_Class_ID();
	virtual void Delete();
	virtual void Import_Creation(BitStreamClass &);
	virtual void Export_Creation(BitStreamClass &);
	virtual void Act();
};

class cChangeTeamEvent : public cNetEvent {
public:
	int ID;
	virtual ~cChangeTeamEvent();
	virtual unsigned int Get_Network_Class_ID();
	virtual void Delete();
	virtual void Import_Creation(BitStreamClass &);
	virtual void Export_Creation(BitStreamClass &);
	virtual void Act();
};

class cClientBboEvent : public cNetEvent {
public:
	int ID;
	int Bandwidth;
	virtual ~cClientBboEvent();
	virtual unsigned int Get_Network_Class_ID();
	virtual void Delete();
	virtual void Import_Creation(BitStreamClass &);
	virtual void Export_Creation(BitStreamClass &);
	virtual void Act();
};

class cClientGoodbyeEvent : public cNetEvent {
public:
	int ID;
	virtual ~cClientGoodbyeEvent();
	virtual unsigned int Get_Network_Class_ID();
	virtual void Delete();
	virtual void Export_Creation(void *BitStream);
	virtual void Import_Creation(void *BitStream);
	virtual void Act();
};

class cCsDamageEvent : public NetworkObjectClass {
public:
	int Damager;
	int DamagerObj;
	int DamagedObj;
	float Damage;
	int Warhead;
	static bool &AreClientsTrusted;
	virtual ~cCsDamageEvent();
	virtual unsigned int Get_Network_Class_ID(void);
	virtual void Act();
	virtual void Import_Creation(BitStreamClass &);
	virtual void Export_Creation(BitStreamClass &);
	virtual void Delete();
};

class cCsTextObj : public cNetEvent {
public:
	int Sender;
	TextMessageEnum Type;
	WideStringClass Message;
	int Receiver;
	virtual ~cCsTextObj();
	virtual unsigned int Get_Network_Class_ID();
	virtual void Import_Creation(BitStreamClass &);
	virtual void Export_Creation(BitStreamClass &);
	virtual void Act();
};

class cGameSpyCsChallengeResponseEvent : public cNetEvent {
public:
	int ID;
	StringClass Hash;
	virtual ~cGameSpyCsChallengeResponseEvent();
	virtual unsigned int Get_Network_Class_ID();
	virtual void Import_Creation(BitStreamClass &);
	virtual void Export_Creation(BitStreamClass &);
	virtual void Act();
};

class cGameSpyScChallengeResponseEvent : public cNetEvent {
public:
	StringClass ChallengeString;
	virtual ~cGameSpyScChallengeResponseEvent();
	virtual unsigned int Get_Network_Class_ID();
	virtual void Delete();
	virtual void Import_Creation(BitStreamClass &);
	virtual void Export_Creation(BitStreamClass &);
	virtual void Act();
	void Init(int ID, StringClass &challenge);
};

#include "fds_player.h"
class cPurchaseRequestEvent : public cNetEvent {
public:
	int ID;
	VendorClass::Purchase_Type Type;
	int Item;
	int Alt_Id; // 0 = Yes, -1 = No
	virtual ~cPurchaseRequestEvent();
	virtual unsigned int Get_Network_Class_ID();
	virtual void Delete();
	virtual void Export_Creation(BitStreamClass &);
	virtual void Import_Creation(BitStreamClass &);
	virtual void Act();
};

class cPurchaseResponseEvent : public cNetEvent {
public:
	int ID;
	int Type;
	virtual ~cPurchaseResponseEvent();
	virtual unsigned int Get_Network_Class_ID();
	virtual void Delete();
	virtual void Export_Creation(BitStreamClass &);
	virtual void Import_Creation(BitStreamClass &);
	virtual void Act();
	void Init(int Type, int ID);
};

class CSAnnouncement : public cNetEvent {
public:
	int Team;
	int ID;
	int RadioID;
	int Key;
	bool SendToTeamOnly;
	virtual ~CSAnnouncement();
	virtual unsigned int Get_Network_Class_ID();
	virtual void Import_Creation(BitStreamClass &);
	virtual void Export_Creation(BitStreamClass &);
	virtual void Act();
};

class cScTextObj : public cNetEvent {
public:
	int SenderId;
	int ReceiverId;
	int Type;
	WideStringClass Message;
	bool IsPopup;
	virtual unsigned int Get_Network_Class_ID();
	virtual void Act();
	virtual void Import_Creation(BitStreamClass &);
	virtual void Export_Creation(BitStreamClass &);
	virtual ~cScTextObj();
	void Init(const WideStringClass &msg, int Type, bool Is_Popup, int From, int To);
	void Set_Dirty_Bit_For_Team(DIRTY_BIT, int);
};

class cSuicideEvent : public cNetEvent {
public:
	int ID;
	virtual unsigned int Get_Network_Class_ID();
	virtual void Init();
	virtual void Act();
	virtual void Delete();
	virtual void Export_Creation(void *BitStream);
	virtual void Import_Creation(void *BitStream);
	virtual ~cSuicideEvent();
	cSuicideEvent();
};

class cWarpEvent : public cNetEvent {
public:
	virtual ~cWarpEvent();
	virtual unsigned int Get_Network_Class_ID(void);
	virtual void Export_Creation(BitStreamClass *bit);
	virtual void Delete();
	virtual void Act();
	virtual void Init(int ,int ,float ,int);
};

class SCAnnouncement : public cNetEvent {
public:
	virtual ~SCAnnouncement();
	virtual unsigned int Get_Network_Class_ID();
	virtual void Import_Creation(BitStreamClass &);
	virtual void Export_Creation(BitStreamClass &);
	virtual void Act();
};

class cWinEvent : public cNetEvent {
public:
	int HostedGameNumber; // 0x6B4
	int Winner; // 0x6B8
	int ID; // 0x6BC
	bool IsMapCycleOver; // 0x6C0
	virtual ~cWinEvent();
	virtual unsigned int Get_Network_Class_ID();
	virtual void Import_Creation(BitStreamClass &);
	virtual void Export_Creation(BitStreamClass &);
	virtual void Act();
};

class cGameDataUpdateEvent : public cNetEvent {
public:
	int HostedGameNumber;
	int TimeRemainingSecs;
	virtual ~cGameDataUpdateEvent();
	virtual unsigned int Get_Network_Class_ID();
	virtual void Import_Creation(BitStreamClass &);
	virtual void Export_Creation(BitStreamClass &);
	virtual void Act();
};

class cNetStats {
public:
	int var0[25]; // 0
	int var64[25]; // 64
	int varC8[25]; // C8
	int var12C[25]; // 12C
	int var190[25]; // 190
	int var1F4[25]; // 1F4
	int Time1; // 258
	int var25C; // 25C
	int var260; // 260
	int var264; // 264
	int Time2; // 268
	int var26C; // 26C
	int var270; // 270
	int var274; // 274
	int ServiceCount; // 278
	int var27C; // 27C
};

class cMsgStatList {
	int Sent;
	int ByteSent;
	int Received;
	int ByteReceived;
	char *Name;
};

class cRemoteHost {
public:
	cNetStats NetStats; // 0
	float Threshold_Priority; // 0x280
	float FlowControl;
	int var288;
	int var28C;
	int LastPacketId; // 0x290
	int LastAckPacketId; // 294
	int DefaultResendTimeoutMs; // 0x298
	int var29C;
	int var2A0;
	unsigned int Ping; // 0x2A4
	int unk2; // 0x2A8
	int unk3; // 0x2AC
	sockaddr_in Address; // 0x2B0 (0x10)
	int PacketId; // 0x2C0
	//SList<cPacket> PacketQueue; // 0x2D0
	char z2[23*4];
	//void **ProcessTime; // 310
	unsigned long LastReceiveKeepAliveMs; // 0x320
	int var324; // 0x324
	bool IsFlowControlEnabled; // 0x328
	unsigned int LastServiceCount; // 0x32C
	unsigned int LastReceivePacketMs; // 0x330
	int BytesSentPerSecond; // 0x334
	int Bandwidth; // 0x338
	int ID; // 0x33C
	float unk6; // 0x340
	int unk7; // 0x344
	bool IsLoading; // 0x348
	bool Expect_Flood; // 0x349
	unsigned long SetFloodStatusTime; // 0x34C
	unsigned long SetLoadStatusTime; // 0x350
	int ResentPackets; // 0x354
	unsigned long JoinTime; // 0x358
	int unk8; // 0x35C
	int unk9; // 0x360
	int TimeoutCounter; // 0x364
	int unk11; // 0x368
	bool unk12; // 0x36C
	int unk13; // 0x370
	int unk14; // 0x374
	int BytesOverBandwidthCount; // 0x378
	int unk16; // 0x37C
};

typedef void (*ConnHandler)(int);
typedef REFUSAL_CODE (*ApplicationAcceptanceHandler)(cPacket &);
class cConnection {
public:
	int MyId; // 0
	short Port; // 4
	char z1[2*4];
	cNetStats NetStats; // 0x10
	cNetStats NetStats2; // 0x290
	unsigned long LastSendKeepAliveMs; // 0x510
	bool IsSinglePlayer; // 0x514
	bool IsDedicated; // 515
	bool ServerStarted; // 516
	SOCKET *socket; // 0x518
	char z2[3*4];
	int Refused_Connection_Count; // 0x528
	int var52C;
	unsigned long Bandwidth_Budget_Out; // 0x530
	SList<cPacket> PacketQueue; // 0x534
	int SentPackets; // 0x540
	int var544; // 0x544
	cRemoteHost **RemoteList; // 0x548
	int var54C; // 0x54C - Client is 0 and Server is 1
	unsigned int MaxConnections; // 0x550
	unsigned int Connection_Count; // 0x554
	bool Client_Connected; // 0x558
	cMsgStatList *MsgStat; // 0x55C
	int ExtraLoadMsCounter; // 0x560
	unsigned long SetExtraLoadStatusMs; // 0x564
	bool IsMapLoaded; // 0x568
	void *Accept_Handler; // 0x56C
	void *Refusal_Handler; // 0x570
	void *Server_Broken_Connection_Handler; // 0x574
	void *Client_Broken_Connection_Handler; // 0x578
	void *Eviction_Handler; // 0x57C
	ConnHandler ConnectionHandler; // 0x580
	ApplicationAcceptanceHandler Application_Acceptance_Handler; // 0x584
	void *Server_Packet_Handler; // 0x588
	void *Client_Packet_Handler; // 0x58C
	void Process_Connection_Request(cPacket &packet);
	int Address_To_Rhostid(const sockaddr_in *sock);
	void Send_Accept_Sc(int ID);
	void Send_Refuse_Sc(sockaddr_in *sock, REFUSAL_CODE code);
	cRemoteHost *Get_Remote_Host(int ID);
};

class cNetwork {
public:
	static cConnection *&PServerConnection;
	static unsigned long &ExeKey;
	static int &Fps;
	static void Server_Send_Packet(cPacket &, int Type, int ClientID);
	static void Send_Object_Update(NetworkObjectClass *obj, int ClientID);
	static void Cleanup_After_Client(int ID);
	static void Server_Kill_Connection(int ID);
};

class PacketManagerClass {
public:
	int Get_Compressed_Bandwidth_Out(sockaddr_in *sock);
};
extern PacketManagerClass *PacketMgr;

class cNetUtil {
public:
	static bool Is_Same_Address(sockaddr_in *sock1, const sockaddr_in *sock2);
};

class cMathUtil {
public:
	static int Round(double);
};

typedef void (*GCDCallBackStruct)(int, int, const char *, int);
struct GCDStruct {
	int PlayerID; // 0x0
	char z[9*4];
	unsigned long CheckID; // 0x28
	unsigned long PlayerIP; // 0x2C
	int Start_Time; // 0x30
	int Retry_Count; // 0x34
	int State; // 0x38
	int unk; // 0x3C - Always 0
	GCDCallBackStruct Callback; // 0x40
	void *unk2; // 0x44
	char *String; // 0x48
	int StringLength; // 0x4C
};

void gcd_init();
void gcd_think();
void gcd_disconnect_user(int ID);
void gcd_disconnect_all();

void Send_Text_Msg(const WideStringClass &msg, int m_Type, bool Is_Popup, int From, int To);
void Request_Serial(int ID);

#endif
