#ifndef FDS_GAME
#define FDS_GAME

// Forwarder
class cGameDataCnc;
class cGameDataSkirmish;
class cGameDataSinglePlayer;
class cPlayer;

class AutoRestartClass {
public:
	void Set_Restart_Flag(bool Flag);
};
extern AutoRestartClass *AutoRestart;

template <class T1,class T2> class TypedEventPair {
	T1 signal;
	T2 data;
};

template <class T> class Signaler {
public:
	bool Dropped;
	virtual void ReceiveSignal(T &signal);
	virtual void SignalDropped(Signaler &sig);
	virtual ~Signaler();
};

struct TIME {
	short wYear;
	short wMonth;
	short wDayOfWeek;
	short wDay;
	short wHour;
	short wMinute;
	short wSecond;
	short wMilliseconds;
};

class WOLGameInfo {
public:
	bool var0;
	bool var1;
	unsigned int ExeKey; // 4
	int GameType; // 8
	char MapName[32]; // C
	char ModName[32]; // 2C
	wchar_t GameTitle[32]; // 4C
	int MinPlayers; // 6C
	int MaxPlayers; // 0x70
	int CurrentPlayers; // 0x74
	unsigned long Clans[2]; // 0x78
	bool var80;
	bool var81;
	bool IsPassworded; // 0x82
	bool IsQuickMatch; // 0x83
	bool IsDedicated; // 0x84
	bool IsFriendlyFirePermitted; // 0x85
	bool GrantWeapons; // 0x86
	bool RemixTeams; // 0x87
	bool IsTeamChangingAllowed; // 0x88
	bool IsClanGame; // 0x89
	bool CanRepairBuildings; // 0x8A
	bool DriverIsAlwaysGunner; // 0x8B
	bool SpawnWeapons; // 0x8C
	int var90;
};

class cGameData2 {
public:
	unsigned int Get_Max_Players(void) {
		return *(int *)(this+0x1F8);
	}
	bool Is_Gameplay_Permitted(void) {
		return *(bool *)0x8550E6;
	}
	bool Set_Max_Players(int Max);
};
extern cGameData2 *&cGame;

class cGameData : public Signaler<TypedEventPair<bool,int> > {
public:
	bool GameplayPermitted; // 0x8
	bool IsDedicated; // 0x9
	bool IsAutoRestart; // 0xA
	bool IsFriendlyFirePermitted; // 0xB
	bool IsTeamChangingAllowed; // 0xC
	bool IsPassworded; // 0xD
	bool GrantWeapons; // 0xE
	bool IsLaddered; // 0xF
	bool IsClanGame; // 0x10
	bool UseLagReduction; // 0x11
	bool RemixTeams; // 0x12
	bool CanRepairBuildings; // 0x13
	bool DriverIsAlwaysGunner; // 0x14
	bool SpawnWeapons; // 0x15
	bool DoMapsLoop; // 0x16
	bool MapCycleOver; // 0x17
	unsigned int MapNumber; // 0x18
	WideStringClass GameTitle; // 0x1C
	WideStringClass Motd; // 0x20
	WideStringClass Password; // 0x24
	StringClass MapName; // 0x28
	StringClass ModName; // 0x2C
	StringClass MapList[100]; // 0x30
	WideStringClass Owner; // 0x1C0
	DynamicVectorClass<WideStringClass> BottomText; // 0x1C4
	DynamicVectorClass<WideStringClass> SettingsLimits; // 0x1DC
	WideStringClass SettingsDescription; // 0x1F4
	unsigned int MaxPlayers; // 0x1F8
	unsigned int TimeLimit_Minutes; // 0x1FC
	unsigned int IntermissionTime_Seconds; // 0x200
	unsigned int ExeKey; // 0x204
	bool ExeVersionsMatch; // 0x208
	bool StringVersionsMatch; // 0x209
	unsigned int IP; // 0x20C
	unsigned int Port; // 0x210
	StringClass INI; // 0x214
	unsigned int RadarMode; // 0x218
	unsigned int CFGModTime; // 0x21C
	unsigned int CurrentPlayers; // 0x220
	float IntermissionTimeLeft; // 0x224
	float TimeRemaining_Seconds; // 0x228
	float MaxWorldDistance; // 0x22C
	unsigned int MinQualifyingTime_Minutes; // 0x230
	unsigned int WinnerID; // 0x234
	unsigned int WinType; // 0x238
	TIME GameStartTime2; // 0x23C
	unsigned int GameStartTime; // 0x24C
	unsigned long FrameCount; // 0x250
	WideStringClass MVPName; // 0x254
	unsigned int MVPCount; // 0x258
	unsigned int GameDuration_Seconds; // 0x25C
	bool IsQuickMatch; // 0x260
	unsigned long Clan1; // 0x264
	unsigned long Clan2; // 0x268
	static bool &IsManualExit;
	virtual void ReceiveSignal(TypedEventPair<bool,int> &signal);
	virtual cGameData::~cGameData();
	virtual void On_Game_Begin();
	virtual void On_Game_End();
	virtual void Think();
	virtual void Render();
	virtual void Reset_Game();
	virtual WideStringClass Get_Game_Name() = 0;
	virtual int Get_Game_Type() = 0;
	virtual int Choose_Player_Type(cPlayer *Player,int type,bool SkipAutoTeam);
	virtual void Load_From_Server_Config();
	virtual void Save_To_Server_Config();
	virtual bool Is_Editable_Teaming();
	virtual bool Is_Editable_Clan_Game();
	virtual bool Is_Editable_Friendly_Fire();
	virtual void Soldier_Added(GameObject *obj);
	virtual void Show_Game_Settings_Limits();
	virtual bool Is_Single_Player();
	virtual bool Is_Skirmish();
	virtual bool Is_Cnc();
	virtual cGameDataSinglePlayer *As_Single_Player();
	virtual cGameDataSkirmish *As_Skirmish();
	virtual cGameDataCnc *As_Cnc();
	virtual unsigned int Get_Min_Players(); // 60
	virtual bool Is_Game_Over();
	virtual bool Is_Limited();
	virtual bool Is_Valid_Settings(WideStringClass &w,bool b);
	virtual void Export_Tier_1_Data(cPacket &packet);
	virtual void Import_Tier_1_Data(cPacket &packet);
	virtual void Import_Tier_1_Data(const WOLGameInfo &packet);
	virtual void Export_Tier_2_Data(cPacket &packet);
	virtual void Import_Tier_2_Data(cPacket &packet);
	virtual bool Is_Gameplay_Permitted();
	virtual bool Remember_Inventory();
	virtual void Get_Description(WideStringClass &w);
	void Rebalance_Team_Sides();
};
extern cGameData *&The_Game;

class cGameDataCnc : public cGameData {
public:
	bool BaseDestructionEndsGame;
	bool BeaconPlacementEndsGame;
	unsigned int StartingCredits;
	BaseControllerClass GDI;
	BaseControllerClass Nod;
	bool BasesInitalized;
	cGameDataCnc::~cGameDataCnc();
	void On_Game_Begin();
	void On_Game_End();
	void Think();
	void Reset_Game();
	WideStringClass Get_Game_Name();
	int Get_Game_Type();
	void Load_From_Server_Config();
	void Save_To_Server_Config();
	bool Is_Editable_Teaming();
	bool Is_Editable_Clan_Game();
	bool Is_Editable_Friendly_Fire();
	void Soldier_Added(GameObject *obj);
	void Show_Game_Settings_Limits();
	bool Is_Cnc();
	cGameDataCnc *As_Cnc();
	bool Is_Game_Over();
	bool Is_Limited();
	bool Is_Valid_Settings(WideStringClass &w,bool b);
	void Export_Tier_2_Data(cPacket &packet);
	void Import_Tier_2_Data(cPacket &packet);
	bool Is_Gameplay_Permitted();
	void Get_Description(WideStringClass &w);
};

class cGameDataSkirmish : public cGameData {
public:
	bool BaseDestructionEndsGame;
	bool BeaconPlacementEndsGame;
	unsigned int StartingCredits;
	BaseControllerClass GDI;
	BaseControllerClass Nod;
	bool BasesInitalized;
	cGameDataSkirmish::~cGameDataSkirmish();
	void On_Game_Begin();
	void On_Game_End();
	void Think();
	void Reset_Game();
	WideStringClass Get_Game_Name();
	int Get_Game_Type();
	void Load_From_Server_Config();
	void Save_To_Server_Config();
	bool Is_Editable_Teaming();
	bool Is_Editable_Clan_Game();
	bool Is_Editable_Friendly_Fire();
	void Soldier_Added(GameObject *obj);
	void Show_Game_Settings_Limits();
	bool Is_Skirmish();
	cGameDataSkirmish *As_Skirmish();
	bool Is_Game_Over();
	bool Is_Limited();
	void Get_Description(WideStringClass &w);
};

class cGameDataSinglePlayer : public cGameData {
public:
	cGameDataSinglePlayer::~cGameDataSinglePlayer();
	WideStringClass Get_Game_Name();
	int Get_Game_Type();
	int Choose_Player_Type(cPlayer *Player,int type,bool SkipAutoTeam);
	bool Is_Single_Player();
	cGameDataSinglePlayer *As_Single_Player();
	bool Is_Limited();
	bool Remember_Inventory();
};

class GameModeClass {
public:
	int State;
	virtual ~GameModeClass();
	virtual void Activate();
	virtual void Deactivate();
	virtual void Safely_Deactivate();
	virtual void Suspend();
	virtual void Resume();
	virtual bool Is_Inactive();
	virtual bool Is_Suspended();
	virtual bool Is_Active();
	virtual char *Name() = 0;
};

class GameModeManager {
public:
	static GameModeClass *Find(const char *Mode);
	static void Think();
};

class WolGameModeClass : public GameModeClass {
public:
	char *Name();
	void Init_WOL_Player(cPlayer *);
	cGameData *Game; // 0xD8
	int varDC;
};

class CombatManager {
public:
	static bool &FriendlyFirePermitted;
	static bool &BeaconPlacementEndsGame;
	static bool &IsGameplayPermitted;
};

class CNCModeSettingsDef : public DefinitionClass {
public:
	int AnnouncementInterval; // 0x1C
	unsigned int Power_Offline_Report[2]; // 0x20 (0x8)
	unsigned int Purchase_Canceled_Report[2]; // 0x28 (0x8)
	unsigned int Insufficient_Funds_Report[2]; // 0x30 (0x8)
	unsigned int Constructing_Report[2]; // 0x38 (0x8)
	unsigned int Unit_Ready_Report[2]; // 0x40 (0x8)
	unsigned int Ion_Beacon_Deployed_Report[2]; // 0x48 (0x8)
	unsigned int Ion_Beacon_Disarmed_Report[2]; // 0x50 (0x8)
	unsigned int Ion_Beacon_Warning_Report[2]; // 0x58 (0x8)
	unsigned int Nuke_Beacon_Deployed_Report[2]; // 0x60 (0x8)
	unsigned int Nuke_Beacon_Disarmed_Report[2]; // 0x68 (0x8)
	unsigned int Nuke_Beacon_Warning_Report[2]; // 0x70 (0x8)
	unsigned int Radio_Command[30]; // 0x78 (0x78)
	StringClass Radio_Command_Emot_Icon[30]; // 0xF0 (0x78)
	static CNCModeSettingsDef *&_mInstance;
};

class GlobalSettingsDef : public DefinitionClass {
public:
	unsigned int DeathSoundID; // 0x1C
	unsigned int EVAObjectivesSoundID; // 0x20
	unsigned int HUDHelpTextSoundID; // 0x24
	float MaxConversationDist; // 0x28
	float MaxCombatConversationDist; // 0x2C
	float SoldierWalkSpeed; // 0x30
	float SoldierCrouchSpeed; // 0x34
	float FallingDamageMinDistance; // 0x38
	float FallingDamageMaxDistance; // 0x3C
	StringClass PurchaseGDITexture; // 0x40
	StringClass PurchaseGDIVehicleTexture; // 0x44
	StringClass PurchaseGDIEquipmentTexture; // 0x48
	StringClass PurchaseNODTexture; // 0x4C
	StringClass PurchaseNODVehicleTexture; // 0x50
	StringClass PurchaseNODEquipmentTexture; // 0x54
	StringClass PurchaseGDIMUTCharactersTexture; // 0x58
	StringClass PurchaseGDIMUTVehiclesTexture; // 0x5C
	StringClass PurchaseGDIMUTEquipmentTexture; // 0x60
	StringClass PurchaseNODMUTCharactersTexture; // 0x64
	StringClass PurchaseNODMUTVehiclesTexture; // 0x68
	StringClass PurchaseNODMUTEquipmentTexture; // 0x6C
	int EncyclopediaEventStringID; // 0x70
	int FallingDamageWarhead; // 0x74
	float StealthDistanceHuman; // 0x78
	float StealthDistanceVehicle; // 0x7C
	float MPStealthDistanceHuman; // 0x80
	float MPStealthDistanceVehicle; // 0x84
	static GlobalSettingsDef *&GlobalSettings;
};

void Set_Exit_On_Exception(bool State);
unsigned int Get_Game_Mode();

#endif
