#
# Serial plugin for BRenBot 1.52.1 by gkl21
# Designed for Adad's Serial.dll
# Version 1.0.1
#
#Define the package name
package serial;

#Define Perl Plugins
use POE;
use plugin;
use DBI;

#Required
our $plugin_name;
our %config;

#Global Variable
our $serialserialdbh;
my $version = 1.0.1;

#These commands are pointers to subs.
our %additional_events =
(
	"rl_playerserial" => "rl_playerserial",
	"sban" => "sban",
	"gethash" => "gethash",
	"banhash" => "banhash",
	"1" => "1"
);

#Initialize the plugin
sub start
{
	my ( $session, $heap, $args ) = @_[ SESSION, HEAP, ARG0 ];
	my $kernel = $_[KERNEL];

	#Force the current directory to BRenBot
	opendir( DIR, '.' );

	#Check to see if the ban.dat file exists, if not, create it, else just load it.
	if ( -e "serial.dat" ) #Does not exist
	{
		$serialdbh = DBI->connect("dbi:SQLite2:dbname=serial.dat","","");
	}
	else
	{
		$serialdbh = DBI->connect("dbi:SQLite2:dbname=serial.dat","","");

		$serialdbh->do(
			"create table serials
			(id INTEGER PRIMARY KEY
			,name	char(128)
			,serial	char(40))");
		$serialdbh->do(
			"create table bans
			(id INTEGER PRIMARY KEY
			,serial	char(40)
			,reason	char(1024)
			,banner	char(50))");
	}

	#Close the directory handle.
	closedir DIR;
}

sub stop
{
	my ( $session, $heap, $args ) = @_[ SESSION, HEAP, ARG0 ];
	my $kernel = $_[KERNEL];

	#Ensure the database link is disconnected.
	$serialdbh->disconnect;
}

#AddSlahes() - Attempt to prevent SQL Injection.
sub AddSlashes {
    my $text = shift;
    ## Make sure to do the backslash first!
    $text =~ s/\\/\\\\/g;
    $text =~ s/'/\\'/g;
    $text =~ s/"/\\"/g;
    $text =~ s/\0/\\\0/g;
    return $text;
}


#Serial hash response from player 1 -> 00000000000000000000aaaaaaaaaaaaaaaaaaaa.

sub rl_playerserial {
	my ( $session, $heap, $args ) = @_[ SESSION, HEAP, ARG0 ];
	my $kernel = $_[KERNEL];
	my $line = $args->{line};
	my $playername;

	$line =~ /Serial\shash\sresponse\sfrom\splayer\s(\d+)\s.+\s(.+)\./;
	#print "Serial data for player ".$1." is ".$2."\n";

	#Get the player name associated with this id.
	if ( $main::version > 1.50 )
	{
		my ( $result, %player ) = plugin::getPlayerData( $1 );
		if ( $result == 1)
		{
			$playername = "$player{name}";
		}
	}
	else
	{
		my ( $result, $error, $player ) = plugin::PlayerInGame ( $1 );
		if ( $result == 1)
		{
			$playername = "$player->{name}";	
		}
	}

	#If a playername was returned.
	if ( $playername ) {
	
		my $query;
		my @row;

		$query = $serialdbh->prepare ( "SELECT * FROM serials WHERE name='".$playername."' AND serial='".$2."'" );
		$query->execute();
		if ( @row = $query->fetchrow_array )
		{
			#Already in the database. Do Nothing.
		}
		else {
			$serialdbh->do ( "INSERT INTO serials ([name], [serial]) VALUES ('".$playername."','".$2."')" );
		}

		checkserial( $playername, $2 );

	}

}

sub checkserial {
	my ($nickname, $serial) = @_;

	if ( $nickname ) {
		if ( $serial ) {

			my $query;
			my @row;

			$query = $serialdbh->prepare ( "SELECT serial, reason, banner FROM bans WHERE serial='".$serial."'" );
			$query->execute();
			if ( @row = $query->fetchrow_array )
			{
				$reason = $row[1];
				$banner = $row[2];
				#plugin::ircmsg( "kb $nickname $reason (Hash Ban)" , "A" );
				plugin::call_command ( "$banner", "kb $nickname $reason (Hash Ban)" );
			}
		}
	}
}

#command() - !irc commands
sub command
{
	# trigger on !commands
	my ( $session, $heap, $args ) = @_[ SESSION, HEAP, ARG0 ];
	my $kernel = $_[KERNEL];
	my %args = %{$args};
	
	if ($args{command} eq "sban") #command name in xml file
	{
		$kernel->yield("sban" => \%args); #sub routing name
	}
	elsif ($args{command} eq "gethash") #command name in xml file
	{
		$kernel->yield("gethash" => \%args); #sub routing name
	}
	elsif ($args{command} eq "banhash") #command name in xml file
	{
		$kernel->yield("banhash" => \%args); #sub routing name
	}
}

sub gethash {
	my ( $session, $heap, $args ) = @_[ SESSION, HEAP, ARG0 ];
	my $kernel = $_[KERNEL];
	my %args = %{$args};

	if ( !$args{arg1} ) { plugin::ircmsg( "Usage: !gethash <player_name>" , $args{'ircChannelCode'} ); }
	else {
		my $results = "false";
		my $resnum = 0;

		my $playername = AddSlashes($args{arg1});
		$query = $serialdbh->prepare ( "SELECT * FROM serials WHERE name LIKE '%".$playername."%' ORDER BY name LIMIT 8" );
		$query->execute();
		while ( @row = $query->fetchrow_array )
		{
			$results = "true";
			plugin::ircmsg( "Hash found for ".$row[1].": ".$row[2] , $args{'ircChannelCode'} );
			$resnum = $resnum + 1;
			if ($resnum >= 8) {
				plugin::ircmsg( "Maximum 8 records showing. Please be more specific." , $args{'ircChannelCode'} );
			}
		}

		if ( $results eq "false" )
		{
			plugin::ircmsg( "No hash for ".$playername." found." , $args{'ircChannelCode'} );
		}
	}
}

sub banhash {
	my ( $session, $heap, $args ) = @_[ SESSION, HEAP, ARG0 ];
	my $kernel = $_[KERNEL];
	my %args = %{$args};

	if ( !$args{arg3} ) { plugin::ircmsg( "Usage: !banhash <player_name> <serial_hash> <reason>" , $args{'ircChannelCode'} ); }
	elsif ( length($args{arg2}) != 40 ) {  plugin::ircmsg( "Invalid Serial Hash Length. Must be 40 characters long." , $args{'ircChannelCode'} ); }
	else {
		my $query; #SQL Query
		my @row; #SQL Data Row

		my $name = AddSlashes($args{arg1});
		my $serial = $args{arg2};
		my $banner = $args{nick};

		#Get the reason for the ban by locating where the ban reason starts
		my $reason = AddSlashes($args{arg});
		my $temp1 = length($args{arg1});
		my $temp2 = length($args{arg2});
		my $temp3 = length($args{arg});

		$reason = substr($reason, ($temp1 + $temp2 + 10), ($temp3 - ($temp1 + $temp2)) );

		#See if the record exists
		$query = $serialdbh->prepare ( "SELECT serial FROM bans WHERE serial='".$serial."'" );
		$query->execute();
		if ( @row = $query->fetchrow_array )
		{
			#A record was found. Do not add a new one.
			plugin::ircmsg( "[Hash Ban] ".$name."'s serial is already banned." , $args{'ircChannelCode'} );
		}
		else 
		{
			my $query2; #SQL Query
			my @row2; #SQL Data Row

			#Check for player in serials table.
			$query2 = $serialdbh->prepare ( "SELECT serial FROM serials WHERE name='".$name."'" );
			$query2->execute();
			if ( @row2 = $query2->fetchrow_array )
			{
				#Found, do nothing.
			}
			else 
			{
				#Add serial into the serials table.
				$serialdbh->do ( "INSERT INTO serials ([name], [serial]) VALUES ('".$name."','".$serial."')" );
			}

			#Add a new ban.
			$serialdbh->do ( "INSERT INTO bans ([serial], [reason], [banner]) VALUES ('".$serial."','".$reason."','".$banner."')" );
			plugin::ircmsg( "[Hash Ban] ".$name." has been hashed ban." , $args{'ircChannelCode'} );

		}
	}
}

sub sban {
	
	my ( $session, $heap, $args ) = @_[ SESSION, HEAP, ARG0 ];
	my $kernel = $_[KERNEL];
	my %args = %{$args};

	if ( !$args{arg2} ) { plugin::ircmsg( "Usage: !sban <add|del|lookup> <player_name> <reason>" , $args{'ircChannelCode'} ); }
	else {
		if ( $args{arg1} eq "add" ) 
		{
			if ( !$args{arg3} ) { plugin::ircmsg( "Usage: !sban <add|del|lookup> <player_name> <reason>" , $args{'ircChannelCode'} ); }
			else {
				#Get the reason for the ban by locating where the ban reason starts
				my $reason = AddSlashes($args{arg});
				my $temp1 = length($args{arg1});
				my $temp2 = length($args{arg2});
				my $temp3 = length($args{arg});

				#Take the full length of the command, minus the '!sban add nickname' to locate the start position, then use that number, minus the entire length to get the rest of the line, aka reason.
				$reason = substr($reason, ($temp1 + $temp2 + 7), ($temp3 - ($temp1 + $temp2)) );

				my $query; #SQL Query
				my @row; #SQL Data Row
				my $serial; #Serial associated with player
				my $banner = $args{nick};
				my $valid = "false";

				#Get the serial.
				$query = $serialdbh->prepare ( "SELECT serial FROM serials WHERE name='".$args{arg2}."'" );
				$query->execute();
				while ( @row = $query->fetchrow_array )
				{
					$serial = $row[0];
					$valid = "true";

					my $query2; #SQL Query
					my @row2; #SQL Data Row

					#See if the record exists
					$query2 = $serialdbh->prepare ( "SELECT serial FROM bans WHERE serial='".$serial."'" );
					$query2->execute();
					if ( @row2 = $query2->fetchrow_array )
					{
						#A record was found. Do not add a new one.
						plugin::ircmsg( "[Hash Ban] A record was already found for ".$args{arg2}."." , $args{'ircChannelCode'} );
					}
					else 
					{
						#Add a new ban.
						$serialdbh->do ( "INSERT INTO bans ([serial], [reason], [banner]) VALUES ('".$serial."','".$reason."','".$banner."')" );
						plugin::ircmsg( "[Hash Ban] ".$args{arg2}." has been hashed ban." , $args{'ircChannelCode'} );
					}
				}
				if ( valid eq "false" ) {
					plugin::ircmsg( "[Hash Ban] No record for ".$args{arg2}." found." , $args{'ircChannelCode'} );
				}
			}
		}
		elsif (  $args{arg1} eq "del" ) 
		{
			my $query; #SQL Query
			my @row; #SQL Data Row
			my $serial; #Serial associated with player
			my $banner = $args{nick};
			my $valid = "false";

			#Get the serial.
			$query = $serialdbh->prepare ( "SELECT serial FROM serials WHERE name='".$args{arg2}."'" );
			$query->execute();
			while ( @row = $query->fetchrow_array )
			{
				$serial = $row[0];
				$valid = "true";

				my $query2; #SQL Query
				my @row2; #SQL Data Row

				#See if the record exists
				$query2 = $serialdbh->prepare ( "SELECT serial FROM bans WHERE serial='".$serial."'" );
				$query2->execute();
				if ( @row2 = $query2->fetchrow_array )
				{
					#A record was found. Delete it.
					$serialdbh->do ( "DELETE FROM bans WHERE serial='".$serial."'" );
					plugin::ircmsg( "[Hash Ban] ".$args{arg2}." is no longer hash banned." , $args{'ircChannelCode'} );
				}
				else 
				{
					#No hash ban found.
					plugin::ircmsg( "[Hash Ban] No hash ban found for ".$args{arg2}."." , $args{'ircChannelCode'} );
				}
			}
			if ( valid eq "false" ) {
				plugin::ircmsg( "[Hash Ban] No record for ".$args{arg2}." found." , $args{'ircChannelCode'} );
			}
		}
		elsif (  $args{arg1} eq "lookup" ) 
		{
			my $query; #SQL Query
			my @row; #SQL Data Row
			my $serial; #Serial associated with player
			my $banner = $args{nick};
			my $valid = "false";

			#Get the serial.
			$query = $serialdbh->prepare ( "SELECT serial FROM serials WHERE name='".$args{arg2}."'" );
			$query->execute();
			while ( @row = $query->fetchrow_array )
			{
				$serial = $row[0];
				$valid = "true";
				my $query2; #SQL Query
				my @row2; #SQL Data Row

				#See if the record exists
				$query2 = $serialdbh->prepare ( "SELECT reason, banner FROM bans WHERE serial='".$serial."'" );
				$query2->execute();
				if ( @row2 = $query2->fetchrow_array )
				{
					#A record was found.
					plugin::ircmsg( "[Hash Ban] ".$args{arg2}." is hash banned by ".$row2[1]." for: ".$row2[0]."." , $args{'ircChannelCode'} );
				}
				else 
				{
					#No hash ban found.
					plugin::ircmsg( "[Hash Ban] No hash ban found for ".$args{arg2}."." , $args{'ircChannelCode'} );
				}
			}
			if ( valid eq "false" ) {
				plugin::ircmsg( "[Hash Ban] No record for ".$args{arg2}." found." , $args{'ircChannelCode'} );
			}
		}
	}
}
1;