
package PluginLib::Functions;
use strict;
use PluginLib::IP::Country::Fast;
#use Data::Dumper;

sub execute_query_database
{
	$| = 1;
	my $sth;
	my $query = shift;
	my $database = shift;
	my $flag = shift;
	$sth = $database->prepare ( "$query" );
	$sth -> execute;
	if (!$flag)
	{
		my $attrib_nr = 0;
		my @array_of_hash_refs;
		my @new_array;
		my $db_line;
	    while ($db_line = $sth->fetchrow_hashref())
	    {
	    	$array_of_hash_refs[$attrib_nr] = $db_line;
			$attrib_nr++;
		}
		undef $attrib_nr;
		foreach (@array_of_hash_refs)
		{
			my %hash = %$_;
			my %hash_lc;
			while ((my $k, my $v) = each %hash)
			{ 
				 $k = lc($k);
				 $hash_lc{$k} = $v;
			}
			push (@new_array,\%hash_lc);
		}
		$#array_of_hash_refs = -1;
		return (@new_array);
	}	
}

sub sendmsg
{
	my ( $msg, $nicktype, $chantype, $username ) = @_;
	if ($nicktype == 1)
	{
		plugin::ircmsg ($msg, $chantype );
	}
	else
	{
		my ( $result, %player ) = plugin::getPlayerData( $username );
		if ( $result == 1 )
		{
			plugin::pagePlayer ( $player{'id'}, "BRenBot", "$msg" );
		}
	}
}

sub remove_player
{
	my ( $msg, $nick, $banner, $reason ) = @_;
	my ($result, %player) = plugin::getPlayerData($nick);
	if ($result == 1)	
	{	
		modules::RenRemCMDtimed( "kick $player{id}", 5 );
		brIRC::ircmsg ( "$nick $msg for $reason by $banner.", "A" );
	}
}

#AddSlahes() - Attempt to prevent SQL Injection.
sub AddSlashes 
{
    my $text = shift;
    $text =~ s/\\/\\\\/g;
    $text =~ s/'/\\'/g;
    $text =~ s/"/\\"/g;
    $text =~ s/\0/\\\0/g;
    return $text;
}

sub GetTeam
{
	my $side = shift;	
	if ( $side =~ m/^NOD$/i ){ $side = 0; }
	else { $side = 1; }
	return $side;	
}

sub GetCountry
{
	my $hostname = shift;
	my $reg = IP::Country::Fast->new();
	$hostname = $reg->inet_atocc($hostname);
	return $hostname;
}

sub getAdminChannelUsers
{
	#my $temp = $brIRC::adminChannelUsers;
	return $brIRC::adminChannelUsers;
}

sub getPublicChannelUsers
{
	#my $temp = $brIRC::publicChannelUsers;
	return $brIRC::publicChannelUsers;
}

sub debugmsg
{
	my $msg = shift;
	my $dbPrefix = "[DEBUG] ";
	$msg = $dbPrefix . $msg;
	plugin::ircmsg ($msg, "A" );
}

sub DebugLog
{
	my $msg	= shift;
	my $dbPrefix = "[DEBUGLOG] ";
	$msg = $dbPrefix . $msg;
	brIRC::sendToServer ( "PRIVMSG #DebugLog :$msg" );
}

sub DebugWrite
{
	my $msg	= shift;
	open ( DEBUGFILE, '>>debug.txt' );
	print DEBUGFILE "$msg\n";
	close DEBUGFILE;
}

#test
#process master database search
sub process_search
{
	#5239 genblacky2 xxxxxx xxxxxxxx xxxxxxxxxx 1291356041
	my $result = shift;
	my $ircUser;
	my $ip;
	my $name;
	my $rndnumber;
	my $dns;
	my $timestamp;
	my $serial;
	my $message;
	if ( $result =~ m/(.+)\sNothing\sfound/i )
	{
		#38012 Nothing found
		$rndnumber = $1;
		$ircUser = getRequestIdOwner ( $rndnumber );
		$message = "No Results Found";		
	}
	elsif ( $result =~ m/(.+)\s(.+)\s(.+)\s(.+)\s(.+)\s(.+)/ )
	{
		$rndnumber = $1; $name = $2;
		$ip = $3;        $serial = $4;
		$dns = $5;       $timestamp = $6;
		my ( $year, $month, $day, $hour, $min, $sec ) = modules::BRTime_To_Date($timestamp);
		$ircUser = getRequestIdOwner ( $rndnumber );
		$message = "[$month/$day/$year] $name $ip $serial $dns";	
	}
	else
	{
		plugin::ircmsg ( "Result Error $result", "A" );
		return;
	}
	
	if ( $ircUser ) { plugin::ircnotice ( $ircUser, $message ); }
	else { plugin::ircmsg ( "$message", "A" ); }	
}

sub Is_mod
{
	my $name = shift;
	if ( modules::IsHalfMod($name)|| 
	modules::IsFullMod($name) || 
	modules::IsAdmin($name) ) 
	#modules::IsOwner($name) || 
	#modules::IsSpecial($name) )
	{
		return 1;
	}
	return 0;
}


sub auto_rec
{
	my $killer = shift;
	my $comment = shift;
	if ( modules::is_rec_ignored( $killer ) )
	{
		modules::RenRemCMD( "msg [BR] $killer was unable to recieve their recommendation for $comment because they have been added to the recignore list by an administrator." );
		return;
	}
	if ( modules::get_module( "autorecs" ) )
	{
		modules::RenRemCMD( "msg [BR] $killer has been recommended by BrenBot: $comment" );
		modules::recommend_player( $killer, "BrenBot", $comment, 1 );
		bhs::playsndp( "bonus_complete.wav", $killer );
	}
}

####################################
## ipbot functions
# Request ID functions
#
# Allocates request ID's and remembers who they
# belong to
##
####################################

# Hash to hold request IDs
my %requestIds;

# Allocate a new request ID
sub getRequestId
{
	my $ircUser = shift;

	# Allocate a random request ID
	my $requestId = int(rand(99999));

	# If this ID is already allocated try another ID until we find a free one
	while ( $requestIds{$requestId} )
		{ $requestId = int(rand(99999)); }

	$requestIds{$requestId} = $ircUser;
	return $requestId;
}

# Get the name of the owner of a request ID
sub getRequestIdOwner
{
	my $requestId = shift;

	if ( $requestIds{$requestId} )
	{
		my $ircUser = $requestIds{$requestId};
		delete $requestIds{$requestId};
		return $ircUser;
	}

	return undef;
}


1;