/*	Renegade Scripts.dll
	Copyright 2011 Tiberian Technologies

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/
#include "General.h"
#include "DeathAnimations.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "gmgame.h"

void* HookupAT3x(void* a, void* b, void* c, void* patch_start, void* patch_end, int (*version_selector)())
{
	return HookupAT3(a,b,c,patch_start,patch_end,version_selector);
}

/*
Some random animation notes/observations

h_a_6x05 Electrocuted but didn't die. Would be a funny reaction to volt auto rifle damage.
h_a_a0a1 Running animation
h_a_a0a2 Running with a glance over left shoulder
h_a_a0j1_01 Running leap
h_a_d11a falling waving arms
h_a_div1 foward roll
h_a_host_l2a surrender on knees hands over head
*/

char *GenericDeathAnims[15] = 
{
	"h_a_601a", "h_a_612a", "h_a_613a", "h_a_622a", "h_a_623a", "h_a_624a", "h_a_631a", "h_a_632a", 
	"h_a_633a", "h_a_634a", "h_a_635a", "h_a_692a", "h_a_693a", "h_a_6x01", "H_A_FLMB"
	
};


DeathAnimations::DeathAnimations()
{
	Console_Output("Loading reborn's Death animation plugin!\n");
	RegisterEvent(EVENT_OBJECT_CREATE_HOOK,this);
	RegisterEvent(EVENT_CHAT_HOOK,this);
}

DeathAnimations::~DeathAnimations()
{
	UnregisterEvent(EVENT_OBJECT_CREATE_HOOK,this);
}



void DeathAnimations::OnObjectCreate(void *data,GameObject *obj)
{
	if(Commands->Is_A_Star(obj))
	{
		Attach_Script_Once(obj, "DeathAnimation", "");
	}
}




void DeathAnimation::Killed(GameObject *obj, GameObject *shooter)
{
	Vector3 Pos = Commands->Get_Position(obj);
	float Facing = Commands->Get_Facing(obj);
	const char *Preset = Commands->Get_Preset_Name(obj);
	Commands->Set_Model(obj, "null");
	Vector3 Pos2 = Pos;
	Pos2.Z += 0.4f;
	Pos2.X += 0.8f;
	Pos2.Y += 0.8f;
	Commands->Set_Position(obj, Pos2);
	Commands->Disable_Physical_Collisions(obj);

	GameObject *Dummy;
	Dummy = Commands->Create_Object(Preset, Pos);
	Commands->Disable_Physical_Collisions(Dummy);
	Commands->Set_Facing(Dummy, Facing);
	Set_Skin(Dummy, "blamo");
	Commands->Set_Shield_Type(Dummy, "blamo");
	Commands->Set_Shield_Strength(Dummy, 0.0f);
	Commands->Set_Health(Dummy, 0.1f);
	Set_Death_Points(Dummy, 0.0f);
	Set_Damage_Points(Dummy, 0.0f);
	Commands->Clear_Weapons(Dummy);
	Commands->Give_PowerUp(Dummy, "CnC_POW_MineTimed_Player_01",false);
	Commands->Select_Weapon(Dummy, "CnC_Weapon_MineTimed_Player");
	Set_Current_Bullets(Dummy, 0);
	Set_Current_Clip_Bullets(Dummy, 0);

	int AnimSize = (sizeof(GenericDeathAnims)/sizeof(char*));
	int Animation2Play = Commands->Get_Random_Int(0, AnimSize);
	Commands->Set_Animation(Dummy, GenericDeathAnims[Animation2Play], false, 0, 0.0f, -1.0f, false);
	Attach_Script_Once(Dummy, "KillDummy", "");
}

ScriptRegistrant<DeathAnimation> DeathAnimation_Script_Registrant("DeathAnimation","");


void KillDummy::Animation_Complete(GameObject *obj, const char *animation_name)
{
	Commands->Destroy_Object(obj);
}

ScriptRegistrant<KillDummy> KillDummy_Script_Registrant("KillDummy","");



DeathAnimations DeathAnimations;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &DeathAnimations;
}
