#include "General.h"
#include "HashTemplateClass.h"
#include "HashTemplateIterator.h"
#include "JoinNameRegulator.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "gmgame.h"

HashTemplateClass<StringClass, StringClass> IllegalCharactersTable; // Contains characters that aren't allowed inside a nick
HashTemplateClass<StringClass, int> IllegalNamesTable; // Contains a list of illegal names, we only use the key for quick lookup
StringClass GuestNick; // The name that will be changed to if a player joins with an illegal name
int GuestAppendDigits; // Amount of randomly generated digits to append to GuestNick
int AllowedNameLength;

void Console(const char *Format, ...)
{
	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);
	Console_Input(buffer);
}

void Limit_Name_Length(WideStringClass WideName, int PlayerID)
{
	if (WideName.Get_Length() > AllowedNameLength)
	{
		int Length = Find_Player(PlayerID)->PlayerName.Get_Length();
		Find_Player(PlayerID)->PlayerName.TruncateRight(Length-AllowedNameLength);

		Console("PAMSG %d Your name has been truncated from '%S' to '%S' because" 
			" it was longer than the %d characters limit allowed.", 
			PlayerID, WideName, Find_Player(PlayerID)->PlayerName, AllowedNameLength);
	}
}

char Get_Random_Number()
{
	LARGE_INTEGER cicles;
	QueryPerformanceCounter(&cicles);

	srand((unsigned int)cicles.QuadPart);
	int i = rand() % 10;
	
	char Buffer[8];
	sprintf(Buffer, "%1d", i);
	return Buffer[0];
}

void Change_Illegal_Name(WideStringClass WideName, int PlayerID)
{
	WideStringClass OriginalName = WideName;
	WideName = GuestNick;

	for (int i = 1; i < GuestAppendDigits; i++)
	{
		WideName += Get_Random_Number();
	}

	Console("PAMSG %d You joined with the illegal name '%S', your name has been changed to '%S'." 
		" Some rare bugs will cause you to join with an illegal name. Just rejoin if that's the case.",
		PlayerID, OriginalName, WideName);

	Find_Player(PlayerID)->PlayerName = WideName;
}

void Replace_Illegal_Characters(WideStringClass WideName, int PlayerID)
{
	char* Name = StringClass(WideName).Peek_Buffer();

	for (int i = 0; Name[i] != NULL; i++) // We convert the name to char* so we can iterate over it in a simple way
	{
		// I'm not happy with this but I apparently can't have a HashTemplateClass with a 'char' type in it ;(
		StringClass Temp = StringClass::getFormattedString("%c", Name[i]);
		StringClass CharFromTable = IllegalCharactersTable.Get(Temp, "0");

		if (CharFromTable != "0")
		{
			char Char = CharFromTable[0];
			Name[i] = Char;
		}
	} 

	Find_Player(PlayerID)->PlayerName.Convert_From(Name);
}

void JoinNameRegulator::OnPlayerJoin(int PlayerID,const char *PlayerName)
{
	WideStringClass WideName = Find_Player(PlayerID)->PlayerName;

	if (IllegalNamesTable.Get(StringClass(WideName), 0))
	{
		Change_Illegal_Name(WideName, PlayerID);
		return;
	}

	Limit_Name_Length(WideName, PlayerID);

	WideName = Find_Player(PlayerID)->PlayerName; // We need to update our variable for the next function
	
	Replace_Illegal_Characters(WideName, PlayerID);
}

JoinNameRegulator::JoinNameRegulator()
{
	RegisterEvent(EVENT_GLOBAL_INI,this);
	RegisterEvent(EVENT_PLAYER_JOIN_HOOK,this);
}

JoinNameRegulator::~JoinNameRegulator()
{
	UnregisterEvent(EVENT_GLOBAL_INI,this);
	UnregisterEvent(EVENT_PLAYER_JOIN_HOOK,this);
}

void JoinNameRegulator::OnLoadGlobalINISettings(INIClass *SSGMIni)
{	
	SSGMIni->Get_String(GuestNick, "JoinNameRegulator", "GuestNick", "Player");
	GuestAppendDigits = SSGMIni->Get_Int("JoinNameRegulator", "GuestAppendDigits", 6);
	AllowedNameLength = SSGMIni->Get_Int("JoinNameRegulator", "AllowedNameLength", 18);

	int Count = SSGMIni->Entry_Count("JoinNameRegulator_IllegalNamesTable");
	for (int i = 0; i < Count; i++)
	{
		const char *Entry = SSGMIni->Get_Entry("JoinNameRegulator_IllegalNamesTable", i);
		StringClass Insert;
		SSGMIni->Get_String(Insert, "JoinNameRegulator_IllegalNamesTable", Entry);
		IllegalNamesTable.Insert(Insert, 1);
	}
	
	Count = SSGMIni->Entry_Count("JoinNameRegulator_IllegalCharactersTable");
	for (int i = 0; i < Count; i++)
	{
		StringClass Entry = SSGMIni->Get_Entry("JoinNameRegulator_IllegalCharactersTable", i);

		if (Entry == "WhiteSpace")
		{
			StringClass Insert;
			SSGMIni->Get_String(Insert, "JoinNameRegulator_IllegalCharactersTable", Entry);
			IllegalCharactersTable.Insert(StringClass(" "), Insert);
			continue;
		}

		StringClass Insert;
		SSGMIni->Get_String(Insert, "JoinNameRegulator_IllegalCharactersTable", Entry);
		IllegalCharactersTable.Insert(Entry, Insert);
	}

/*	for (HashTemplateIterator<StringClass, int> iter(IllegalNamesTable); iter; ++iter)
	{
		Console_Output("IllegalNamesTable: %s\n", iter.getKey());
	}

	for (HashTemplateIterator<StringClass, StringClass> iter(IllegalCharactersTable); iter; ++iter)
	{
		Console_Output("IllegalCharactersTable: %s\n", iter.getKey());
	} */
}

JoinNameRegulator joinNameRegulator;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &joinNameRegulator;
}
