#include "General.h"
#include "BuildingRevivalConsoleCommands.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "engine_game.h"
#include "gmgame.h"
#include "Iterator.h"
#include "BuildingGameObjDef.h"
#include "VehicleFactoryGameObj.h"
#include "VehicleFactoryGameObjDef.h"
#include "BaseControllerClass.h"
#include "PhysicalGameObj.h"

#define GDI 1
#define NOD 0

void Revive_Building(GameObject *Building)
{
	if (Is_Building_Dead(Building))
	{
		Restore_Building(Building);
		float max = Commands->Get_Max_Health(Building);
		Commands->Set_Health(Building, max);



		if (Is_Base_Powered(Get_Object_Type(Building)))
		{
			Commands->Set_Building_Power(Building, true);
		}
		else
		{
			Commands->Set_Building_Power(Building, false);
		}
		
	/*	BaseControllerClass* base = BaseControllerClass::Find_Base(Get_Object_Type(Building));
		if (base) 
		{
			if (Is_VehicleFactory(Building))
				base->Set_Can_Generate_Vehicles(true);
		}*/
		Commands->Apply_Damage(Building, 1.0f, "Shrapnel", 0); // DEBUG CRAP
	}
}

class CommandREVIVEBAR :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "revivebar"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVEBAR - Revives the GDI Barracks."; 
	}
	void Activate(const char* argumentsString)
	{
		Revive_Building(Find_Soldier_Factory(GDI));
	}
};

class CommandREVIVEHON :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "revivehon"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVEHON - Revives the Hand of Nod."; 
	}
	void Activate(const char* argumentsString)
	{
		Revive_Building(Find_Soldier_Factory(NOD));
	}
};

class CommandREVIVEGDIPP :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "revivegdipp"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVEGDIPP - Revives the GDI Power Plant."; 
	}
	void Activate(const char* argumentsString)
	{
		Revive_Building(Find_Power_Plant(GDI));
		Commands->Set_Building_Power(Find_Power_Plant(GDI), true);
		Commands->Set_Building_Power(Find_Building_By_Type(GDI, BuildingConstants::TYPE_BASE_DEFENSE), true);
		Commands->Set_Building_Power(Find_Building_By_Type(GDI, BuildingConstants::TYPE_HELIPAD), true);
		Commands->Set_Building_Power(Find_Building_By_Type(GDI, BuildingConstants::TYPE_COUNT), true);
		Commands->Set_Building_Power(Find_Building_By_Type(GDI, BuildingConstants::TYPE_SPECIAL), true);
		Commands->Set_Building_Power(Find_Building_By_Type(GDI, BuildingConstants::TYPE_SHRINE), true);
		Commands->Set_Building_Power(Find_Building_By_Type(GDI, BuildingConstants::TYPE_NONE), true);
		Commands->Set_Building_Power(Find_Construction_Yard(GDI), true);
		Commands->Set_Building_Power(Find_Refinery(GDI), true);
		Commands->Set_Building_Power(Find_Repair_Bay(GDI), true);
		Commands->Set_Building_Power(Find_Soldier_Factory(GDI), true);
		Commands->Set_Building_Power(Find_Vehicle_Factory(GDI), true);
		Commands->Set_Building_Power(Find_Com_Center(GDI), true);

		if (!Is_Script_Attached(Find_Building_By_Type(GDI, BuildingConstants::TYPE_BASE_DEFENSE),"GDI_AGT"))
		{
			char params[64];
			sprintf(params,"%d", Commands->Get_ID(Find_Building_By_Type(GDI, BuildingConstants::TYPE_BASE_DEFENSE)));
			Remove_Script(Find_Building_By_Type(GDI, BuildingConstants::TYPE_BASE_DEFENSE),"GDI_AGT");
			Remove_Script(Find_Building_By_Type(GDI, BuildingConstants::TYPE_BASE_DEFENSE),"M00_Advanced_Guard_Tower");
			Commands->Attach_Script(Find_Building_By_Type(GDI, BuildingConstants::TYPE_BASE_DEFENSE), "GDI_AGT", params);
		}
	}
};

class CommandREVIVENODPP :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "revivenodpp"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVENODPP - Revives the Nod Power Plant."; 
	}
	void Activate(const char* argumentsString)
	{
		Revive_Building(Find_Power_Plant(NOD));
		Commands->Set_Building_Power(Find_Power_Plant(NOD), true);
		Commands->Set_Building_Power(Find_Building_By_Type(NOD, BuildingConstants::TYPE_BASE_DEFENSE), true);
		Commands->Set_Building_Power(Find_Building_By_Type(NOD, BuildingConstants::TYPE_HELIPAD), true);
		Commands->Set_Building_Power(Find_Building_By_Type(NOD, BuildingConstants::TYPE_COUNT), true);
		Commands->Set_Building_Power(Find_Building_By_Type(NOD, BuildingConstants::TYPE_SPECIAL), true);
		Commands->Set_Building_Power(Find_Building_By_Type(NOD, BuildingConstants::TYPE_SHRINE), true);
		Commands->Set_Building_Power(Find_Building_By_Type(NOD, BuildingConstants::TYPE_NONE), true);
		Commands->Set_Building_Power(Find_Construction_Yard(NOD), true);
		Commands->Set_Building_Power(Find_Refinery(NOD), true);
		Commands->Set_Building_Power(Find_Repair_Bay(NOD), true);
		Commands->Set_Building_Power(Find_Soldier_Factory(NOD), true);
		Commands->Set_Building_Power(Find_Vehicle_Factory(NOD), true);
		Commands->Set_Building_Power(Find_Com_Center(NOD), true);

		if (!Is_Script_Attached(Find_Building_By_Type(NOD, BuildingConstants::TYPE_BASE_DEFENSE),"Nod_Obelisk_CnC_Ground"))
		{
			char params[64];
			sprintf(params,"%d", Commands->Get_ID(Find_Building_By_Type(NOD, BuildingConstants::TYPE_BASE_DEFENSE)));
			Remove_Script(Find_Building_By_Type(NOD, BuildingConstants::TYPE_BASE_DEFENSE),"Nod_Obelisk_CnC_Ground");
			Remove_Script(Find_Building_By_Type(NOD, BuildingConstants::TYPE_BASE_DEFENSE),"M00_Nod_Obelisk_Cnc");
			Commands->Attach_Script(Find_Building_By_Type(NOD, BuildingConstants::TYPE_BASE_DEFENSE), "Nod_Obelisk_CnC_Ground", params);
		}
	}
};

class CommandREVIVEGDICONYARD :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "revivegdiconyard"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVEGDICONYARD - Revives the GDI Construction Yard."; 
	}
	void Activate(const char* argumentsString)
	{
		Revive_Building(Find_Construction_Yard(GDI));
	}
};

class CommandREVIVENODCONYARD :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "revivenodconyard"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVENODCONYARD - Revives the Nod Construction Yard."; 
	}
	void Activate(const char* argumentsString)
	{
		Revive_Building(Find_Construction_Yard(NOD));
	}
};

class CommandREVIVEGDIREF :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "revivegdiref"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVEGDIREF - Revives the GDI Refinery."; 
	}
	void Activate(const char* argumentsString)
	{
		Revive_Building(Find_Refinery(GDI));
	}
};

class CommandREVIVENODREF :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "revivenodref"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVENODREF - Revives the Nod Refinery."; 
	}
	void Activate(const char* argumentsString)
	{
		Revive_Building(Find_Refinery(NOD));
	}
};

class CommandREVIVEGDIREPBAY :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "revivegdirepbay"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVEGDIREPBAY - Revives the GDI Repair Bay."; 
	}
	void Activate(const char* argumentsString)
	{
		Revive_Building(Find_Repair_Bay(GDI));
	}
};

class CommandREVIVENODREPBAY :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "revivenodrepbay"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVENODREPBAY - Revives the Nod Repair Bay."; 
	}
	void Activate(const char* argumentsString)
	{
		Revive_Building(Find_Repair_Bay(NOD));
	}
};

class CommandREVIVEWF :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "revivewf"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVEWF - Revives the GDI Weapons Factory."; 
	}
	void Activate(const char* argumentsString)
	{
		Revive_Building(Find_Vehicle_Factory(GDI));
	}
};

class CommandREVIVEAIR :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "reviveair"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVEAIR - Revives the Nod Airstrip."; 
	}
	void Activate(const char* argumentsString)
	{
		Revive_Building(Find_Vehicle_Factory(NOD));
	}
};

class CommandREVIVEGDICOMMCENTER :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "revivegdicommcenter"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVEGDICOMMCENTER - Revives the GDI Communications Center."; 
	}
	void Activate(const char* argumentsString)
	{
		Revive_Building(Find_Com_Center(GDI));
	}
};

class CommandREVIVENODCOMMCENTER :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "revivenodcommcenter"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVENODCOMMCENTER - Revives the Nod Communications Center."; 
	}
	void Activate(const char* argumentsString)
	{
		Revive_Building(Find_Com_Center(NOD));
	}
};

class CommandREVIVEAGT :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "reviveagt"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVEAGT - Revives the GDI Advanced Guard Tower."; 
	}
	void Activate(const char* argumentsString)
	{
		GameObject *AGT = Find_Building_By_Type(GDI, BuildingConstants::TYPE_BASE_DEFENSE);
		Revive_Building(AGT);

		if	(!Is_Building_Dead(Find_Power_Plant(GDI)))
		{
			char params[64];
			sprintf(params,"%d", Commands->Get_ID(AGT));
			Remove_Script(AGT,"GDI_AGT");
			Remove_Script(AGT,"M00_Advanced_Guard_Tower");
			Commands->Attach_Script(AGT, "GDI_AGT", params);
		}
	}
};

class CommandREVIVEOB :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "reviveob"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVEOB - Revives the Nod Obelisk."; 
	}
	void Activate(const char* argumentsString, GameObject *obj)
	{
		GameObject *Obelisk = Find_Building_By_Type(NOD, BuildingConstants::TYPE_BASE_DEFENSE);
		Revive_Building(Obelisk);

		if (!Is_Building_Dead(Find_Power_Plant(GDI)))
		{
			char params[64];
			sprintf(params,"%d", Commands->Get_ID(Obelisk));
			Remove_Script(Obelisk,"Nod_Obelisk_CnC_Ground");
			Remove_Script(Obelisk,"M00_Nod_Obelisk_CnC");
			Commands->Attach_Script(Obelisk, "Nod_Obelisk_CnC_Ground", params);
		}
	}
};

class BUILDINGREVIVALCONSOLECOMMANDS : public Plugin
{
public:
	BUILDINGREVIVALCONSOLECOMMANDS()
	{
		ConsoleFunctionList.Add(new CommandREVIVEBAR);
		ConsoleFunctionList.Add(new CommandREVIVEHON);
		ConsoleFunctionList.Add(new CommandREVIVEGDIPP);
		ConsoleFunctionList.Add(new CommandREVIVENODPP);
		ConsoleFunctionList.Add(new CommandREVIVEGDICONYARD);
		ConsoleFunctionList.Add(new CommandREVIVENODCONYARD);
		ConsoleFunctionList.Add(new CommandREVIVEGDIREF);
		ConsoleFunctionList.Add(new CommandREVIVENODREF);
		ConsoleFunctionList.Add(new CommandREVIVEGDIREPBAY);
		ConsoleFunctionList.Add(new CommandREVIVENODREPBAY);
		ConsoleFunctionList.Add(new CommandREVIVEWF);
		ConsoleFunctionList.Add(new CommandREVIVEAIR);
		ConsoleFunctionList.Add(new CommandREVIVEGDICOMMCENTER);
		ConsoleFunctionList.Add(new CommandREVIVENODCOMMCENTER);
		ConsoleFunctionList.Add(new CommandREVIVEAGT);
		ConsoleFunctionList.Add(new CommandREVIVEOB);
		Sort_Function_List();
		Verbose_Help_File();
	}
	~BUILDINGREVIVALCONSOLECOMMANDS()
	{
		const DynamicVectorClass<ConsoleFunctionClass*> consoleFunctions(ConsoleFunctionList);
		TT_FOREACH(consoleFunction, consoleFunctions)
		{
			const char* name = (*consoleFunction)->Get_Name();
			if (name)
			{ // DEBUG CRAP NEED TO UPDATE THE STRCMPS
				if (strcmp(name, "revivebar") == 0 || strcmp(name, "revivehon") == 0 || strcmp(name, "revivegdipp") == 0 || strcmp(name, "revivenodpp") == 0 || strcmp(name, "revivegdiconyard") == 0 || strcmp(name, "revivenodconyard") == 0 || strcmp(name, "revivegdiref") == 0 || strcmp(name, "revivenodref") == 0 || strcmp(name, "revivegdirepbay") == 0 || strcmp(name, "revivenodrepbay") == 0 || strcmp(name, "revivewf") == 0 || strcmp(name, "reviveair") == 0 || strcmp(name, "revivegdicommcenter") == 0 || strcmp(name, "revivenodcommcenter") == 0 || strcmp(name, "reviveagt") == 0 ||strcmp(name, "reviveob") == 0) 
				{
					ConsoleFunctionList.Delete(consoleFunction);
				}
			}
		}
	}	
};

BUILDINGREVIVALCONSOLECOMMANDS buildingrevivalconsolecommands;


extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &buildingrevivalconsolecommands;
}