/*	Renegade Scripts.dll
	Main SSAOW scripts and functions
	Copyright 2006 Vloktboky, WhiteDragon(MDB), Mac, Jonathan Wilson

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/

#pragma warning(disable: 4702)

struct Setting {
	Setting();
	bool ReportBuildingDamage;
	bool ReportBuildingDeath;
	bool BuildingDeathRewardPage;
	float BuildingDamageInt;
	bool AFKKick;
	int AFKWait;
	char AFKPageMessage[200];
	bool DropWeapons;
	bool ShowPlayerPurchase;
	bool ShowPlayerKillMessage;
	bool Weather;
	char WeatherType[30];
	bool LogVehCreate;
	bool LogVehDeath;
	bool PlayVehDeathAnim;
	bool EnableVehicleDamageAnim;
	bool LogHarvesterDeath;
	char OBGPageMessage[200];
	bool OBGEnable;
	//Settings added in Version 1.1
	bool DestroyPlayerVeh;
	//Settings added in Version 1.2 and 1.3
	bool DisableBaseDefenses;
	bool DisablePowerPlants;
	bool DisableRefineries;
	bool DisableSoldierFactories;
	bool DisableVehicleFactories;
	bool DisableRepairPads;
	bool DisableCommCenters;
	//settings added in 1.31 through 1.34
	bool Gamelog;
	bool EnableVehicleWreckages;
	bool EnableCrates;
	//settings added in 1.4
	bool DefenseShell;
	bool EnableNewCrates;
	bool VehCrate;
	bool CombatRefill;
	unsigned int RefillTime;
	bool EnableVehOwn;
	int GameMode;
	bool InvinBuild;
	bool DisableBeacons;
	bool Log;
	bool EchoLog;
	bool Gamelog_Archive_Logfiles;
	bool SpawnWeap;
	bool NewGamelog;
	int ForceTeam;
	//Settings added in 1.5
	bool BWDetector;
	int BWDefault;
	bool BWPunishKick;
	bool MergeGamelogRenlog;
};

class M00_BUILDING_EXPLODE_NO_DAMAGE_DAK : public ScriptImpClass {
	void Created(GameObject *obj);
	void Killed(GameObject *obj, GameObject *shooter);
	void Damaged(GameObject *obj, GameObject *damager, float damage);
	void Timer_Expired(GameObject *obj, int number);
	bool ReportDamage;
	int LastID, B2BCount;
	bool PlayHealth, OkHealth, PlayRepair;
	bool IsAlive;
};

class M00_Disable_Transition : public ScriptImpClass {
	void Created(GameObject *obj);
	void Damaged(GameObject *obj, GameObject *damager, float damage);
	void Killed(GameObject *obj, GameObject *shooter);
	void Timer_Expired(GameObject *obj, int number);
	bool PlayDamage;
};

class M00_GrantPowerup_Created : public ScriptImpClass {
	void Created(GameObject *obj);
	void Destroyed(GameObject *obj);
	void Damaged(GameObject *obj, GameObject *damager, float damage);
	void Killed(GameObject *obj, GameObject *shooter);
	void Timer_Expired(GameObject *obj, int number);
	GameObject *BackpackObject;
	GameObject *BackpackScript;
	Vector3 DeathPlace;
	Vector3 SpawnPos;
	int AfkDetect;
	bool DidEvent, FullDeath,WasKilled;
	float TotalHealth;
};

class KAK_Beacon_Log : public ScriptImpClass {
	void Created(GameObject *obj);
	void Destroyed(GameObject *obj);
	void Killed(GameObject *obj, GameObject *shooter);
	void Damaged(GameObject *obj, GameObject *damager, float damage);
	bool IsDisarmed;
	GameObject *InvisObjCont;
};

class KAK_Beacon_Animation_Log : public ScriptImpClass {
	void Created(GameObject *obj);
};

class KAK_Beacon_Log_CreateControl : public ScriptImpClass {
	void Created(GameObject *obj);
	void Timer_Expired(GameObject *obj, int number);
};

class KAK_Random_Weather : public ScriptImpClass {
	void Created(GameObject *obj);
	void Timer_Expired(GameObject *obj, int number);
	float Range, CurrentClouds, CurrentRain, CurrentLightning, CurrentSnow, CurrentAsh, CurrentWind, FogEnd;
};

class KAK_Vehicle_Log : public ScriptImpClass {
	void Created(GameObject *obj);
	void Killed(GameObject *obj, GameObject *shooter);
	Vector3 DeadPlace;
	float Facing;
};

class KAK_Destroy_Tank : public ScriptImpClass {
	void Created(GameObject *obj);
};

class KAK_Obelisk_Powerup : public ScriptImpClass {
	void Created(GameObject *obj);
	void Custom(GameObject *obj, int message, int param, GameObject *sender);
	void Timer_Expired(GameObject *obj, int number);
	GameObject *Powerup;
	bool IsPowerup;
	int LastID, ObGlitchCount;
};

class M00_PCT_Pokable_DAK : public ScriptImpClass {
	void Damaged(GameObject *obj, GameObject *damager, float damage);
	void Killed(GameObject *obj, GameObject *shooter);
	void Poked(GameObject *obj,GameObject * poker);
	void Timer_Expired(GameObject *obj, int number);
};

class KAK_CargoPlane_Sounds : public ScriptImpClass {
	void Created(GameObject *obj);
	void Timer_Expired(GameObject *obj, int number);
	void Damaged(GameObject *obj, GameObject *damager, float damage);
};

class KAK_Disable_List : public ScriptImpClass {
	void Created(GameObject *obj);
	void Timer_Expired(GameObject *obj, int number);
};

class KAK_Drop_Weapon : public ScriptImpClass {
	void Custom(GameObject *obj, int message, int param, GameObject *sender);
	void Created(GameObject *obj);
	void Timer_Expired(GameObject *obj, int number);
};

class KAK_Vehicle_Death : public ScriptImpClass {
	void Created(GameObject *obj);
	void Damaged(GameObject *obj, GameObject *damager, float damage);
	int MaxHealth, CurrHealth;
	GameObject *DestroyedTank;
	Vector3 DeadPlace;
	float Facing;
	Vector3 Pos;
};

class MDB_Block_Refill : public ScriptImpClass {
	void Created(GameObject *obj);
	void Damaged(GameObject *obj, GameObject *damager, float damage);
	void Timer_Expired(GameObject *obj, int number);
	float currhealth,currshield;
	int LastDamage;
};

class MDB_Vehicle_Owner : public ScriptImpClass {
	void Created(GameObject *obj);
	void Custom(GameObject *obj, int message, int param, GameObject *sender);
	void Killed(GameObject *obj, GameObject *shooter);
	void Destroyed(GameObject *obj);
	void Detach(GameObject *obj);
	void Timer_Expired(GameObject *obj, int number);
	int MyOwner(int Type);
	int Team,IconID,IconID2;
	bool IsLocked;
	char msg[512];
};

class MDB_Spawn_Weapon : public ScriptImpClass {
	void Created(GameObject *obj);
};


class KAK_Vehicle_Damage : public ScriptImpClass {
	int VehDamageTimerNew;
	void Created(GameObject *obj);
	void Destroyed(GameObject *obj);
	void Timer_Expired(GameObject *obj, int number);
	bool IsFirstShow, IsSecondShow, Sent;
	float TotalHealth, CurrentHealth;
	int Fire1ID, Fire2ID, Fire3ID, Fire4ID, Explosion1ID, Explosion2ID;
	int Size;
	bool NoExp1, NoExp2, IsStealth;
};

class MDB_Destroy_When_Object_Destroyed : public ScriptImpClass {
	void Created(GameObject *obj);
	void Timer_Expired(GameObject *obj, int number);
	int ID;
};

class MDB_Manager : public ScriptImpClass {
	void Created(GameObject *obj);
	void Timer_Expired(GameObject *obj, int number);
	void Destroyed(GameObject *obj);
};


class ObjectHookClass {
public:
	void NewObject(GameObject *obj);
	void Start();
	~ObjectHookClass();
	ObjectCreateHookStruct *o;
private:
	int id;
};

void VehicleOwner(int ID,int Type);
void WriteLog(const char *Message, bool ShowTime);
void add_stealth_user(const char* name);
void FDSMessage(const char*, const char*);
char *FirstMap();
char *LoadSettingStringFirstMap(const char *Setting,const char *Default,bool Global,bool Map);
extern Setting *Settings;
extern char CurrMap[30];
extern bool FirstBuilding,FirstObject;
void RecognizeMap(bool IsLoad);
extern const char* Ver;
bool IsDisabled(const char *Preset);
bool IsDisabled(GameObject *obj);
