/*	Renegade Scripts.dll
	Scripts for major gameplay elements (including scripts for specific buildings, units etc)
	Copyright 2006 E!, Jonathan Wilson

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/
#include "scripts.h"
#include "engine.h"
#include "jfwgame.h"

void JFW_Team_DM_Zone::Exited(GameObject *obj,GameObject *exit)
{
	int x;
	int msg;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(exit,x))
	{
		return;
	}
	msg = Get_Int_Parameter("Deactivate_Message");
	triggered = false;
	Commands->Send_Custom_Event(obj,exit,msg,1,0);
	if (!triggered)
	{
		char param[100];
		sprintf(param,"%d,%d,%d",Get_Int_Parameter("Controller_ID"),Get_Int_Parameter("Deactivate_Message"),Get_Int_Parameter("Death_Message"));
		Commands->Attach_Script(exit,"JFW_Team_DM_Attatched",param);
	}
}

void JFW_Team_DM_Zone::Custom(GameObject *obj,int message,int param,GameObject *sender)
{
	int msg;
	msg = Get_Int_Parameter("Deactivate_Message");
	if (message == msg)
	{
		triggered = true;
	}
}

void JFW_Team_DM_Controller::Custom(GameObject *obj,int message,int param,GameObject *sender)
{
	int msg;
	int maxdeaths;
	int id;
	GameObject *tmpObj;
	float maxHealth;
	msg = Get_Int_Parameter("Death_Message");
	maxdeaths = Get_Int_Parameter("Deaths_To_Loose");
	if (message == msg)
	{
		deaths++;
	}
	if (deaths >= maxdeaths)
	{
		id = Get_Int_Parameter("Building_To_Destroy1");
		tmpObj = Commands->Find_Object(id);
		maxHealth = Commands->Get_Max_Health(tmpObj);
		Commands->Apply_Damage(tmpObj,10000,"Explosive",0);
		id = Get_Int_Parameter("Building_To_Destroy2");
		tmpObj = Commands->Find_Object(id);
		maxHealth = Commands->Get_Max_Health(tmpObj);
		Commands->Apply_Damage(tmpObj,10000,"Explosive",0);
		id = Get_Int_Parameter("Building_To_Destroy3");
		tmpObj = Commands->Find_Object(id);
		maxHealth = Commands->Get_Max_Health(tmpObj);
		Commands->Apply_Damage(tmpObj,10000,"Explosive",0);
		id = Get_Int_Parameter("Building_To_Destroy4");
		tmpObj = Commands->Find_Object(id);
		maxHealth = Commands->Get_Max_Health(tmpObj);
		Commands->Apply_Damage(tmpObj,10000,"Explosive",0);
		id = Get_Int_Parameter("Building_To_Destroy5");
		tmpObj = Commands->Find_Object(id);
		maxHealth = Commands->Get_Max_Health(tmpObj);
		Commands->Apply_Damage(tmpObj,10000,"Explosive",0);
	}
}

void JFW_Team_DM_Attatched::Custom(GameObject *obj,int message,int param,GameObject *sender)
{
	int msg;
	msg = Get_Int_Parameter("Deactivate_Message");
	if (message == msg)
	{
		Commands->Send_Custom_Event(obj,sender,msg,1,0);
	}
}

void JFW_Team_DM_Controller::Created(GameObject *obj)
{
	deaths = 0;
}

void JFW_Team_DM_Attatched::Killed(GameObject *obj,GameObject *shooter)
{
	int msg;
	int controller_id;
	GameObject *controller;
	msg = Get_Int_Parameter("Death_Message");
	controller_id = Get_Int_Parameter("Controller_ID");
	controller = Commands->Find_Object(controller_id);
	Commands->Send_Custom_Event(obj,controller,msg,1,0);
}

void JFW_Team_DM_Controller::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&deaths);
}

void JFW_Team_DM_Zone::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&triggered);
}

void JFW_Assault_Powerplant_Controller::Created(GameObject *obj)
{
	float timertime;
	int timernumber;
	int poweroff;
	int building;
	GameObject *object;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	poweroff = Get_Int_Parameter("Power_Off");
	Commands->Start_Timer(obj,this,timertime,timernumber);
	building = Get_Int_Parameter("Building1");
	object = Commands->Find_Object(building);
	Commands->Send_Custom_Event(obj,object,poweroff,0,0);
	building = Get_Int_Parameter("Building2");
	object = Commands->Find_Object(building);
	Commands->Send_Custom_Event(obj,object,poweroff,0,0);
	building = Get_Int_Parameter("Building3");
	object = Commands->Find_Object(building);
	Commands->Send_Custom_Event(obj,object,poweroff,0,0);
	building = Get_Int_Parameter("Building4");
	object = Commands->Find_Object(building);
	Commands->Send_Custom_Event(obj,object,poweroff,0,0);
	building = Get_Int_Parameter("Building5");
	object = Commands->Find_Object(building);
	Commands->Send_Custom_Event(obj,object,poweroff,0,0);
	building = Get_Int_Parameter("Building6");
	object = Commands->Find_Object(building);
	Commands->Send_Custom_Event(obj,object,poweroff,0,0);
	building = Get_Int_Parameter("Building7");
	object = Commands->Find_Object(building);
	Commands->Send_Custom_Event(obj,object,poweroff,0,0);
	building = Get_Int_Parameter("Building8");
	object = Commands->Find_Object(building);
	Commands->Send_Custom_Event(obj,object,poweroff,0,0);
	building = Get_Int_Parameter("Building9");
	object = Commands->Find_Object(building);
	Commands->Send_Custom_Event(obj,object,poweroff,0,0);
	building = Get_Int_Parameter("Building10");
	object = Commands->Find_Object(building);
	Commands->Send_Custom_Event(obj,object,poweroff,0,0);
	building = Get_Int_Parameter("Building11");
	object = Commands->Find_Object(building);
	Commands->Send_Custom_Event(obj,object,poweroff,0,0);
	building = Get_Int_Parameter("Building12");
	object = Commands->Find_Object(building);
	Commands->Send_Custom_Event(obj,object,poweroff,0,0);
	building = Get_Int_Parameter("Building13");
	object = Commands->Find_Object(building);
	Commands->Send_Custom_Event(obj,object,poweroff,0,0);
	building = Get_Int_Parameter("Building14");
	object = Commands->Find_Object(building);
	Commands->Send_Custom_Event(obj,object,poweroff,0,0);
	building = Get_Int_Parameter("Building15");
	object = Commands->Find_Object(building);
	Commands->Send_Custom_Event(obj,object,poweroff,0,0);
	inzone = false;
}

void JFW_Assault_Powerplant_Controller::Timer_Expired(GameObject *obj,int number)
{
	int timernumber;
	int poweroff;
	int building;
	GameObject *object;
	timernumber = Get_Int_Parameter("TimerNum");
	poweroff = Get_Int_Parameter("Power_Off");
	if ((!inzone) && (number == timernumber))
	{
		building = Get_Int_Parameter("Building1");
		object = Commands->Find_Object(building);
		Commands->Send_Custom_Event(obj,object,poweroff,0,0);
		building = Get_Int_Parameter("Building2");
		object = Commands->Find_Object(building);
		Commands->Send_Custom_Event(obj,object,poweroff,0,0);
		building = Get_Int_Parameter("Building3");
		object = Commands->Find_Object(building);
		Commands->Send_Custom_Event(obj,object,poweroff,0,0);
		building = Get_Int_Parameter("Building4");
		object = Commands->Find_Object(building);
		Commands->Send_Custom_Event(obj,object,poweroff,0,0);
		building = Get_Int_Parameter("Building5");
		object = Commands->Find_Object(building);
		Commands->Send_Custom_Event(obj,object,poweroff,0,0);
		building = Get_Int_Parameter("Building6");
		object = Commands->Find_Object(building);
		Commands->Send_Custom_Event(obj,object,poweroff,0,0);
		building = Get_Int_Parameter("Building7");
		object = Commands->Find_Object(building);
		Commands->Send_Custom_Event(obj,object,poweroff,0,0);
		building = Get_Int_Parameter("Building8");
		object = Commands->Find_Object(building);
		Commands->Send_Custom_Event(obj,object,poweroff,0,0);
		building = Get_Int_Parameter("Building9");
		object = Commands->Find_Object(building);
		Commands->Send_Custom_Event(obj,object,poweroff,0,0);
		building = Get_Int_Parameter("Building10");
		object = Commands->Find_Object(building);
		Commands->Send_Custom_Event(obj,object,poweroff,0,0);
		building = Get_Int_Parameter("Building11");
		object = Commands->Find_Object(building);
		Commands->Send_Custom_Event(obj,object,poweroff,0,0);
		building = Get_Int_Parameter("Building12");
		object = Commands->Find_Object(building);
		Commands->Send_Custom_Event(obj,object,poweroff,0,0);
		building = Get_Int_Parameter("Building13");
		object = Commands->Find_Object(building);
		Commands->Send_Custom_Event(obj,object,poweroff,0,0);
		building = Get_Int_Parameter("Building14");
		object = Commands->Find_Object(building);
		Commands->Send_Custom_Event(obj,object,poweroff,0,0);
		building = Get_Int_Parameter("Building15");
		object = Commands->Find_Object(building);
		Commands->Send_Custom_Event(obj,object,poweroff,0,0);
	}
}

void JFW_Assault_Powerplant_Controller::Entered(GameObject *obj,GameObject *enter)
{
	int x;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,x))
	{
		return;
	}
	inzone = true;
}

void JFW_Assault_Powerplant_Controller::Exited(GameObject *obj,GameObject *exit)
{
	int x;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(exit,x))
	{
		return;
	}
	inzone = false;
}

void JFW_Assault_Powerplant_Controller::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&inzone);
}

void JFW_Resource_Collector::Created(GameObject *obj)
{
	cash = 0;
	ID = 0;
}

void JFW_Resource_Collector::Custom(GameObject *obj,int message,int param,GameObject *sender)
{
	int Collected_Message = Get_Int_Parameter("Collected_Mesasge");
	int Refinery_Message = Get_Int_Parameter("Refinery_Message");
	int Cash_Limit = Get_Int_Parameter("Cash_Limit");
	int Cash_Type = Get_Int_Parameter("Cash_Type");
	int Entire_Team = Get_Int_Parameter("Entire_Team");
	if (message == CUSTOM_EVENT_VEHICLE_ENTER)
	{
		int OldID;
		OldID = ID;
		ID = Commands->Get_ID(sender);
		if (!Cash_Type)
		{
			cash = 0;
		}
		if ((Cash_Type == 1) && (ID != OldID))
		{
			cash = 0;
		}
	}
	if (message == Collected_Message)
	{
		if (Cash_Type == 3)
		{
			cash = 0;
		}
		cash += param;
		if ((cash > Cash_Limit) && (Cash_Limit))
		{
			cash = Cash_Limit;
		}
	}
	if (message == Refinery_Message)
	{
		Commands->Give_Money(Commands->Find_Object(ID),(float)cash,Entire_Team);
		cash = 0;
	}
}

void JFW_Resource_Collector::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&cash);
	Auto_Save_Variable(1,4,&ID);
}

void JFW_Resource_Refinery::Entered(GameObject *obj,GameObject *enter)
{
	int Refinery_Message = Get_Int_Parameter("Refinery_Message");
	Commands->Send_Custom_Event(obj,enter,Refinery_Message,0,0);
}

void JFW_Resource_Field::Created(GameObject *obj)
{
	ID = 0;
}

void JFW_Resource_Field::Entered(GameObject *obj,GameObject *enter)
{
	const char *Nod_Preset = Get_Parameter("Nod_Preset");
	const char *Preset = Commands->Get_Preset_Name(enter);
	const char *GDI_Preset = Get_Parameter("GDI_Preset");
	if (!ID)
	{
		if ((!stricmp(Preset,Nod_Preset)) || (!stricmp(Preset,GDI_Preset)))
		{
			ID = Commands->Get_ID(enter);
			Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),Get_Int_Parameter("TimerNum"));
			Commands->Send_Custom_Event(obj,enter,Get_Int_Parameter("StartHarvest"),0,0);
		}
	}
}

void JFW_Resource_Field::Exited(GameObject *obj,GameObject *exit)
{
	if (Commands->Get_ID(exit) == ID)
	{
		ID = 0;
		//This line added by NeoSaber:
		Commands->Send_Custom_Event(obj,exit,Get_Int_Parameter("StopHarvest"),0,0);
	}
}

void JFW_Resource_Field::Timer_Expired(GameObject *obj,int number)
{
	int Cash = Get_Int_Parameter("Cash");
	int Collected_Message = Get_Int_Parameter("Collected_Message");
	Vector3 pos;
	float angle;
	GameObject *object;
	const char *Collected_Preset = Get_Parameter("Collected_Preset");
	float Collected_Preset_Distance = Get_Float_Parameter("Collected_Preset_Distance");
	if (ID)
	{
		object = Commands->Find_Object(ID);
		Commands->Send_Custom_Event(obj,object,Collected_Message,Cash,0);
		pos = Commands->Get_Position(object);
		angle = Commands->Get_Facing(object);
		pos.X+=Collected_Preset_Distance*(float)cos(angle);
		pos.Y+=Collected_Preset_Distance*(float)sin(angle);
		Commands->Create_Object(Collected_Preset,pos);
		Commands->Send_Custom_Event(obj,object,Get_Int_Parameter("StopHarvest"),0,0);
	}
}

void JFW_Resource_Field::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&ID);
}

void JFW_Domination_Zone::Created(GameObject *obj)
{
	enabled = true;
	GameObject *object;
	float facing;
	object = Commands->Create_Object("Generic_Cinematic",Commands->Get_Position(obj));
	Commands->Enable_Hibernation(object,false);
	Commands->Add_To_Dirty_Cull_List(object);
	Commands->Set_Model(object,Get_Parameter("Neutral_Model"));
	facing = Commands->Get_Facing(obj);
	Commands->Set_Facing(object,facing);
	currentmodelid = Commands->Get_ID(object);
	owner = 2;
}

void JFW_Domination_Zone::Entered(GameObject *obj,GameObject *enter)
{
	float timertime;
	int timernumber;
	GameObject *object;
	float facing;
	int message;
	if (!enabled)
	{
		return;
	}
	if (Commands->Get_Player_Type(enter) == owner)
	{
		return;
	}
	if (owner == 2)
	{
		message = Get_Int_Parameter("NeutralMessage");
	}
	else
	{
		message = Get_Int_Parameter("OwnedMessage");
	}
	Commands->Destroy_Object(Commands->Find_Object(currentmodelid));
	object = Commands->Create_Object("Generic_Cinematic",Commands->Get_Position(obj));
	Commands->Enable_Hibernation(object,false);
	Commands->Add_To_Dirty_Cull_List(object);
	if (!Commands->Get_Player_Type(enter))
	{
		Commands->Set_Model(object,Get_Parameter("Nod_Model"));
		owner = 0;
	}
	if (Commands->Get_Player_Type(enter) == 1)
	{
		Commands->Set_Model(object,Get_Parameter("GDI_Model"));
		owner = 1;
	}
	facing = Commands->Get_Facing(obj);
	Commands->Set_Facing(object,facing);
	currentmodelid = Commands->Get_ID(object);
	object = Commands->Find_Object(Get_Int_Parameter("Controler_ID"));
	Commands->Send_Custom_Event(obj,object,message,owner,0);
	enabled = false;
	timertime = Get_Float_Parameter("Capture_Delay_Time");
	timernumber = Get_Int_Parameter("TimerNum");
	if (timertime)
	{
		Commands->Start_Timer(obj,this,timertime,timernumber);
	}
	else
	{
		enabled = true;
	}
}

void JFW_Domination_Zone::Timer_Expired(GameObject *obj,int number)
{
	enabled = true;
}

void JFW_Domination_Zone::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&currentmodelid);
	Auto_Save_Variable(2,1,&enabled);
	Auto_Save_Variable(3,4,&owner);
}

void JFW_Domination_Controler::Created(GameObject *obj)
{
	float timertime;
	int timernumber;
	gdizonecount = 0;
	nodzonecount = 0;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	Commands->Start_Timer(obj,this,timertime,timernumber);
}

void JFW_Domination_Controler::Custom(GameObject *obj,int message,int param,GameObject *sender)
{
	int neutralmessage;
	int ownedmessage;
	neutralmessage = Get_Int_Parameter("NeutralMessage");
	ownedmessage = Get_Int_Parameter("OwnedMessage");
	if (message == ownedmessage)
	{
		if (!param)
		{
			gdizonecount--;
		}
		else
		{
			nodzonecount--;
		}
	}
	if ((message == neutralmessage) || (message == ownedmessage))
	{
		if (param == 1)
		{
			gdizonecount++;
		}
		else
		{
			nodzonecount++;
		}
	}
}

void JFW_Domination_Controler::Timer_Expired(GameObject *obj,int number)
{
	float timertime;
	int timernumber;
	float pointstogive;
	float pointstotake;
	GameObject *gdiobject;
	GameObject *nodobject;
	gdiobject = Commands->Find_Object(Get_Int_Parameter("GDIObjectID"));
	nodobject = Commands->Find_Object(Get_Int_Parameter("NodObjectID"));
	pointstogive = Get_Float_Parameter("PointsToGive");
	pointstotake = Get_Float_Parameter("PointsToTake");
	if (gdizonecount > 0)
	{
		if (pointstogive)
		{
			Commands->Give_Points(gdiobject,pointstogive*gdizonecount,true);
		}
		if (pointstotake)
		{
			Commands->Give_Points(nodobject,-(pointstotake*gdizonecount),true);
		}
	}
	if (nodzonecount > 0)
	{
		if (pointstogive)
		{
			Commands->Give_Points(nodobject,pointstogive*nodzonecount,true);
		}
		if (pointstotake)
		{
			Commands->Give_Points(gdiobject,-(pointstotake*nodzonecount),true);
		}
	}
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	Commands->Start_Timer(obj,this,timertime,timernumber);
}

void JFW_Domination_Controler::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&gdizonecount);
	Auto_Save_Variable(2,4,&nodzonecount);
}

void JFW_Iron_Curtain_Zone::Created(GameObject *obj)
{
	enabled = false;
	float timertime;
	int timernumber;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	Commands->Start_Timer(obj,this,timertime,timernumber);
	Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OffID")),true);
	Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OnID")),false);
}

void JFW_Iron_Curtain_Zone::Entered(GameObject *obj,GameObject *enter)
{
	char params[1000];
	float timertime;
	int timernumber;
	const char *scriptname;
	Vector3 position;
	GameObject *object;
	float facing;
	int Player_Type = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,Player_Type)) 
	{
		return;
	}
	if (!enabled)
	{
		return;
	}
	if (Is_Vehicle(enter))
	{
		enabled = false;
		timertime = Get_Float_Parameter("Time");
		timernumber = Get_Int_Parameter("TimerNum");
		Commands->Start_Timer(obj,this,timertime,timernumber);
		if (Get_Int_Parameter("CinematicPowerOff") == 1)
		{
			Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OnID")),false);
			Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OffID")),false);
		}
		scriptname = Get_Parameter("Animation2");
		position = Get_Vector3_Parameter("Animation2Loc");
		facing = Get_Float_Parameter("Animation2Facing");
		object = Commands->Create_Object("Invisible_Object",position);
		Commands->Set_Facing(object,facing);
		Commands->Attach_Script(object,"Test_Cinematic",scriptname);
		Commands->Send_Custom_Event(obj,object,10000+Get_Int_Parameter("Animation2Slot"),Get_Int_Parameter("BuildingID"),0);
		sprintf(params,"%s,%s",Get_Parameter("Invunlerability_Time"),Get_Parameter("Invunlerability_TimerNum"));
		Commands->Attach_Script(enter,"JFW_Invulnerability_Timer",params);
	}
}

void JFW_Iron_Curtain_Zone::Killed(GameObject *obj,GameObject *shooter)
{
	if (enabled)
	{
		if (Get_Int_Parameter("CinematicPowerOff") == 1)
		{
			Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OnID")),false);
			Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OffID")),false);
		}
		const char *scriptname;
		Vector3 position;
		GameObject *object;
		float facing;
		scriptname = Get_Parameter("Animation3");
		position = Get_Vector3_Parameter("Animation3Loc");
		facing = Get_Float_Parameter("Animation3Facing");
		object = Commands->Create_Object("Invisible_Object",position);
		Commands->Set_Facing(object,facing);
		Commands->Attach_Script(object,"Test_Cinematic",scriptname);
		Commands->Send_Custom_Event(obj,object,10000+Get_Int_Parameter("Animation3Slot"),Get_Int_Parameter("BuildingID"),0);
	}
}

void JFW_Iron_Curtain_Zone::Timer_Expired(GameObject *obj,int number)
{
	const char *scriptname;
	Vector3 position;
	GameObject *object;
	float facing;
	int num;
	num = Get_Int_Parameter("TimerNum");
	if (num == number)
	{
		if (Get_Int_Parameter("CinematicPowerOff") == 1)
		{
			Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OnID")),false);
			Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OffID")),false);
		}
		scriptname = Get_Parameter("Animation1");
		position = Get_Vector3_Parameter("Animation1Loc");
		facing = Get_Float_Parameter("Animation1Facing");
		object = Commands->Create_Object("Invisible_Object",position);
		Commands->Set_Facing(object,facing);
		Commands->Attach_Script(object,"Test_Cinematic",scriptname);
		Commands->Send_Custom_Event(obj,object,10000+Get_Int_Parameter("Animation1Slot"),Get_Int_Parameter("BuildingID"),0);
		enabled = true;
	}
}

void JFW_Iron_Curtain_Zone::Custom(GameObject *obj,int message,int param,GameObject *sender)
{
	const char *scriptname;
	Vector3 position;
	GameObject *object;
	float facing;
	if (message == Get_Int_Parameter("Animation1Msg"))
	{
		Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OnID")),true);
		Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OffID")),false);
	}
	if (message == Get_Int_Parameter("Animation2Msg"))
	{
		scriptname = Get_Parameter("Animation3");
		position = Get_Vector3_Parameter("Animation3Loc");
		facing = Get_Float_Parameter("Animation3Facing");
		object = Commands->Create_Object("Invisible_Object",position);
		Commands->Set_Facing(object,facing);
		Commands->Attach_Script(object,"Test_Cinematic",scriptname);
		Commands->Send_Custom_Event(obj,object,10000+Get_Int_Parameter("Animation3Slot"),Get_Int_Parameter("BuildingID"),0);
	}
	if (message == Get_Int_Parameter("Animation3Msg"))
	{
		Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OnID")),false);
		Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OffID")),true);
	}
}

void JFW_Iron_Curtain_Zone::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&enabled);
}

void JFW_Chrono_Controler_Zone::Created(GameObject *obj)
{
	enabled = false;
	activating = false;
	xpos = 0;
	ypos = 0;
	zpos = 0;
	float timertime;
	int timernumber;
	timertime = Get_Float_Parameter("Spawner_Time");
	timernumber = Get_Int_Parameter("Spawner_TimerNum");
	Commands->Start_Timer(obj,this,timertime,timernumber);
	Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OnID")),false);
	Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OffID")),true);
}

void JFW_Chrono_Controler_Zone::Custom(GameObject *obj,int message,int param,GameObject *sender)
{
	float timertime;
	int timernumber;
	int msg = Get_Int_Parameter("Message");
	const char *scriptname;
	Vector3 position;
	GameObject *object;
	float facing;
	if (message == msg)
	{
		Vector3 pos = Commands->Get_Position(sender);
		xpos = pos.X;
		ypos = pos.Y;
		zpos = pos.Z;
		activating = true;
		timertime = Get_Float_Parameter("Activate_Time");
		timernumber = Get_Int_Parameter("Activate_TimerNum");
		Commands->Start_Timer(obj,this,timertime,timernumber);
	}
	if (message == Get_Int_Parameter("DeathMessage"))
	{
		activating = false;
	}
	if (message == Get_Int_Parameter("Animation1Msg"))
	{
		Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OnID")),true);
		Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OffID")),false);
	}
	if (message == Get_Int_Parameter("Animation2Msg"))
	{
		scriptname = Get_Parameter("Animation3");
		position = Get_Vector3_Parameter("Animation3Loc");
		facing = Get_Float_Parameter("Animation3Facing");
		object = Commands->Create_Object("Invisible_Object",position);
		Commands->Set_Facing(object,facing);
		Commands->Attach_Script(object,"Test_Cinematic",scriptname);
		Commands->Send_Custom_Event(obj,object,10000+Get_Int_Parameter("Animation3Slot"),Get_Int_Parameter("BuildingID"),0);
	}
	if (message == Get_Int_Parameter("Animation3Msg"))
	{
		Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OnID")),false);
		Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OffID")),true);
		timertime = Get_Float_Parameter("Spawner_Time");
		timernumber = Get_Int_Parameter("Spawner_TimerNum");
		Commands->Start_Timer(obj,this,timertime,timernumber);
	}
}

void JFW_Chrono_Controler_Zone::Entered(GameObject *obj,GameObject *enter)
{
	const char *scriptname;
	Vector3 position;
	GameObject *object;
	float facing;
	if (!enabled)
	{
		return;
	}
	if (Is_Vehicle(enter))
	{
		enabled = false;
		if (Get_Int_Parameter("CinematicPowerOff") == 1)
		{
			Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OnID")),false);
			Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OffID")),false);
		}
		scriptname = Get_Parameter("Animation2");
		position = Get_Vector3_Parameter("Animation2Loc");
		facing = Get_Float_Parameter("Animation2Facing");
		object = Commands->Create_Object("Invisible_Object",position);
		Commands->Set_Facing(object,facing);
		Commands->Attach_Script(object,"Test_Cinematic",scriptname);
		Commands->Send_Custom_Event(obj,object,10000+Get_Int_Parameter("Animation2Slot"),Get_Int_Parameter("BuildingID"),0);
		Vector3 pos;
		pos.X = xpos;
		pos.Y = ypos;
		pos.Z = zpos+Get_Float_Parameter("ZAdjust");
		Commands->Set_Position(enter,pos);
	}
}

void JFW_Chrono_Controler_Zone::Timer_Expired(GameObject *obj,int number)
{
	const char *scriptname;
	Vector3 position;
	GameObject *object;
	float facing;
	int num;
	num = Get_Int_Parameter("Activate_TimerNum");
	if (num == number)
	{
		if (activating)
		{
			if (Get_Int_Parameter("CinematicPowerOff") == 1)
			{
				Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OnID")),false);
				Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OffID")),false);
			}
			scriptname = Get_Parameter("Animation1");
			position = Get_Vector3_Parameter("Animation1Loc");
			facing = Get_Float_Parameter("Animation1Facing");
			object = Commands->Create_Object("Invisible_Object",position);
			Commands->Set_Facing(object,facing);
			Commands->Attach_Script(object,"Test_Cinematic",scriptname);
			Commands->Send_Custom_Event(obj,object,10000+Get_Int_Parameter("Animation1Slot"),Get_Int_Parameter("BuildingID"),0);
			enabled = true;
			float timertime;
			int timernumber;
			timertime = Get_Float_Parameter("Chrono_Time");
			timernumber = Get_Int_Parameter("Chrono_TimerNum");
			Commands->Start_Timer(obj,this,timertime,timernumber);
		}
	}
	num = Get_Int_Parameter("Spawner_TimerNum");
	if (num == number)
	{
		Commands->Create_Object(Get_Parameter("Spawner_Preset"),Get_Vector3_Parameter("Spawner_Location"));
	}
	num = Get_Int_Parameter("Chrono_TimerNum");
	if ((num == number) && (enabled))
	{
		enabled = false;
		if (Get_Int_Parameter("CinematicPowerOff") == 1)
		{
			Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OnID")),false);
			Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OffID")),false);
		}
		scriptname = Get_Parameter("Animation3");
		position = Get_Vector3_Parameter("Animation3Loc");
		facing = Get_Float_Parameter("Animation3Facing");
		object = Commands->Create_Object("Invisible_Object",position);
		Commands->Set_Facing(object,facing);
		Commands->Attach_Script(object,"Test_Cinematic",scriptname);
		Commands->Send_Custom_Event(obj,object,10000+Get_Int_Parameter("Animation3Slot"),Get_Int_Parameter("BuildingID"),0);
	}
}

void JFW_Chrono_Controler_Zone::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&enabled);
	Auto_Save_Variable(2,4,&xpos);
	Auto_Save_Variable(3,4,&ypos);
	Auto_Save_Variable(4,4,&zpos);
	Auto_Save_Variable(5,1,&activating);
}

void JFW_Chrono_Controler_Zone::Killed(GameObject *obj,GameObject *shooter)
{
	if (enabled)
	{
		if (Get_Int_Parameter("CinematicPowerOff") == 1)
		{
			Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OnID")),false);
			Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OffID")),false);
		}
		const char *scriptname;
		Vector3 position;
		GameObject *object;
		float facing;
		scriptname = Get_Parameter("Animation3");
		position = Get_Vector3_Parameter("Animation3Loc");
		facing = Get_Float_Parameter("Animation3Facing");
		object = Commands->Create_Object("Invisible_Object",position);
		Commands->Set_Facing(object,facing);
		Commands->Attach_Script(object,"Test_Cinematic",scriptname);
		Commands->Send_Custom_Event(obj,object,10000+Get_Int_Parameter("Animation3Slot"),Get_Int_Parameter("BuildingID"),0);
	}
}

void JFW_Conyard::Created(GameObject *obj)
{
	disabled = false;
	Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),Get_Int_Parameter("TimerNum"));
}

void JFW_Conyard::Killed(GameObject *obj,GameObject *shooter)
{
	disabled = true;
}

void JFW_Conyard::Custom(GameObject *obj,int message,int param,GameObject *sender)
{
	if (message == Get_Int_Parameter("DisableCustom"))
	{
		disabled = true;
	}
}

void JFW_Conyard::Timer_Expired(GameObject *obj,int number)
{
	if (!disabled)
	{
		Repair_All_Buildings_By_Team(Get_Object_Type(obj),Commands->Get_ID(obj),Get_Float_Parameter("Health"));
		Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),Get_Int_Parameter("TimerNum"));
	}
}

void JFW_Conyard::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&disabled);
}

void JFW_Flying_Infantry::Created(GameObject *obj)
{
	Toggle_Fly_Mode(obj);
}

void JFW_Flying_Infantry_Custom::Custom(GameObject *obj,int message,int param,GameObject *sender)
{
	if (message == Get_Int_Parameter("Message"))
	{
		Toggle_Fly_Mode(obj);
	}
}

void JFW_Flying_Infantry_Powerup::Custom(GameObject *obj,int message,int param,GameObject *sender)
{
	if (message == CUSTOM_EVENT_POWERUP)
	{
		Toggle_Fly_Mode(sender);
	}
}

void JFW_Flying_Infantry_Enter::Entered(GameObject *obj,GameObject *enter)
{
	int x;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,x))
	{
		return;
	}
	Toggle_Fly_Mode(enter);
}

void JFW_Flying_Infantry_Exit::Exited(GameObject *obj,GameObject *exit)
{
	int x;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(exit,x))
	{
		return;
	}
	Toggle_Fly_Mode(exit);
}

void JFW_Conyard_Vehicle_Buildings::Created(GameObject *obj)
{
	disabled = false;
	Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),Get_Int_Parameter("TimerNum"));
}

void JFW_Conyard_Vehicle_Buildings::Killed(GameObject *obj,GameObject *shooter)
{
	disabled = true;
}

void JFW_Conyard_Vehicle_Buildings::Custom(GameObject *obj,int message,int param,GameObject *sender)
{
	if (message == Get_Int_Parameter("DisableCustom"))
	{
		disabled = true;
	}
}

void JFW_Conyard_Vehicle_Buildings::Timer_Expired(GameObject *obj,int number)
{
	if (!disabled)
	{
		Repair_All_Buildings_By_Team(Get_Object_Type(obj),Commands->Get_ID(obj),Get_Float_Parameter("Health"));
		Repair_All_Static_Vehicles_By_Team(Get_Object_Type(obj),Get_Int_Parameter("Message"));
		Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),Get_Int_Parameter("TimerNum"));
	}
}

void JFW_Conyard_Vehicle_Buildings::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&disabled);
}

void JFW_Drone_Damage::Created(GameObject *obj)
{
	enabled = false;
}

void JFW_Drone_Damage::Custom(GameObject *obj,int message,int param,GameObject *sender)
{
	if ((!message) && (enabled))
	{
		float health = Commands->Get_Health(obj);
		Commands->Set_Health(obj,health-Get_Int_Parameter("Amount"));
		health = Commands->Get_Shield_Strength(obj);
		Commands->Set_Shield_Strength(obj,health-Get_Int_Parameter("Amount"));
		Commands->Send_Custom_Event(obj,obj,0,0,1.0);
	}
}

void JFW_Drone_Damage::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&enabled);
}

void JFW_Drone_Damage::Damaged(GameObject *obj,GameObject *damager,float damage)
{
	GameObject *o = Get_Vehicle(damager);
	if (o)
	{
		damager = o;
	}
	if ((damage < 0) && (Get_Int_Parameter("RepairStop") == 1))
	{
		enabled = false;
	}
	if (!stricmp(Get_Parameter("Preset"),Commands->Get_Preset_Name(damager)))
	{
		enabled = true;
		Commands->Send_Custom_Event(obj,damager,Get_Int_Parameter("Custom"),0,0);
		Commands->Send_Custom_Event(obj,obj,0,0,0);
	}
}

void JFW_Team_DM_Controller_2::Custom(GameObject *obj,int message,int param,GameObject *sender)
{
	int msg;
	int maxdeaths;
	msg = Get_Int_Parameter("Death_Message");
	maxdeaths = Get_Int_Parameter("Deaths_To_Loose");
	if (message == msg)
	{
		deaths++;
	}
	if (deaths >= maxdeaths)
	{
		Kill_All_Buildings_By_Team(Get_Int_Parameter("Team"));
	}
}

void JFW_Team_DM_Controller_2::Created(GameObject *obj)
{
	deaths = 0;
}

void JFW_Team_DM_Controller_2::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&deaths);
}

void JFW_Vehicle_Thief::Damaged(GameObject *obj,GameObject *damager,float damage)
{
	int team;
	team = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(damager,team))
	{
		return;
	}
	if (stricmp(Get_Current_Weapon(damager),Get_Parameter("Weapon")))
	{
		return;
	}
	Force_Occupants_Exit(obj);
}

void JFW_Vehicle_Thief_2::Damaged(GameObject *obj,GameObject *damager,float damage)
{
	int team;
	team = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(damager,team))
	{
		return;
	}
	if (stricmp(Get_Current_Weapon(damager),Get_Parameter("Weapon")))
	{
		return;
	}
	Commands->Create_Sound(Get_Parameter("Sound"),Commands->Get_Position(damager),damager);
	Force_Occupants_Exit(obj);
}

void JFW_Domination_Controler_End_Game::Created(GameObject *obj)
{
	float timertime;
	int timernumber;
	gdizonecount = 0;
	nodzonecount = 0;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	Commands->Start_Timer(obj,this,timertime,timernumber);
}

void JFW_Domination_Controler_End_Game::Custom(GameObject *obj,int message,int param,GameObject *sender)
{
	int neutralmessage;
	int ownedmessage;
	neutralmessage = Get_Int_Parameter("NeutralMessage");
	ownedmessage = Get_Int_Parameter("OwnedMessage");
	if (message == ownedmessage)
	{
		if (!param)
		{
			gdizonecount--;
		}
		else
		{
			nodzonecount--;
		}
	}
	if ((message == neutralmessage) || (message == ownedmessage))
	{
		if (param == 1)
		{
			gdizonecount++;
		}
		else
		{
			nodzonecount++;
		}
	}
	if (gdizonecount == Get_Int_Parameter("ZoneCount"))
	{
		Kill_All_Buildings_By_Team(0);
	}
	if (nodzonecount == Get_Int_Parameter("ZoneCount"))
	{
		Kill_All_Buildings_By_Team(1);
	}
}

void JFW_Domination_Controler_End_Game::Timer_Expired(GameObject *obj,int number)
{
	float timertime;
	int timernumber;
	float pointstogive;
	float pointstotake;
	GameObject *gdiobject;
	GameObject *nodobject;
	gdiobject = Commands->Find_Object(Get_Int_Parameter("GDIObjectID"));
	nodobject = Commands->Find_Object(Get_Int_Parameter("NodObjectID"));
	pointstogive = Get_Float_Parameter("PointsToGive");
	pointstotake = Get_Float_Parameter("PointsToTake");
	if (gdizonecount > 0)
	{
		if (pointstogive)
		{
			Commands->Give_Points(gdiobject,pointstogive*gdizonecount,true);
		}
		if (pointstotake)
		{
			Commands->Give_Points(nodobject,-(pointstotake*gdizonecount),true);
		}
	}
	if (nodzonecount > 0)
	{
		if (pointstogive)
		{
			Commands->Give_Points(nodobject,pointstogive*nodzonecount,true);
		}
		if (pointstotake)
		{
			Commands->Give_Points(gdiobject,-(pointstotake*nodzonecount),true);
		}
	}
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	Commands->Start_Timer(obj,this,timertime,timernumber);
}

void JFW_Domination_Controler_End_Game::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&gdizonecount);
	Auto_Save_Variable(2,4,&nodzonecount);
}

void JFW_Carryable_Vehicle::Damaged(GameObject *obj,GameObject *damager,float damage)
{
	int onlyempty;
	onlyempty = Get_Int_Parameter("Only_Empty");
	if ((onlyempty == 1 && !Get_Vehicle_Occupant_Count(obj)) || (!onlyempty))
	{
		Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter("Control_ID")),9876,Commands->Get_ID(damager),0);
	}
}

void JFW_Carryable_Vehicle::Killed(GameObject *obj,GameObject *shooter)
{
	Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter("Control_ID")),9875,Commands->Get_ID(shooter),0);
}

void JFW_CarryAll::Created(GameObject *obj)
{
	pilotID = 0;
	carrying = false;
	Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter("Control_ID")),9877,6,0);
}

void JFW_CarryAll::Custom(GameObject *obj,int message,int param,GameObject *sender)
{
	if ((message == CUSTOM_EVENT_VEHICLE_ENTER) && (!pilotID))
	{
		pilotID = Commands->Get_ID(sender);
	}
	if ((message == CUSTOM_EVENT_VEHICLE_EXIT) && (Commands->Get_ID(sender) == pilotID))
	{
		pilotID = 0;
	}
	if (message == 9876 && param == pilotID && !carrying)
	{
		carrying = true;
		id = Commands->Get_ID(sender);
		Commands->Set_Position(sender,Commands->Get_Bone_Position(obj,Get_Parameter("Bone_Name")));
		Commands->Attach_To_Object_Bone(sender,obj,Get_Parameter("Bone_Name"));
	}
	if (message == 9877 && param == 7)
	{
		if (pilotID)
		{
			Commands->Give_Money(Commands->Find_Object(pilotID),Get_Float_Parameter("Cost"),false);
		}
		Commands->Destroy_Object(obj);
	}
	if (message == 9875 && carrying && id == Commands->Get_ID(sender))
	{
		carrying = false;
	}
}

void JFW_CarryAll::Damaged(GameObject *obj,GameObject *damager,float damage)
{
	if (carrying && damager == Commands->Find_Object(pilotID))
	{
		float facing = Commands->Get_Facing(Commands->Find_Object(id));
		float health = Commands->Get_Health(Commands->Find_Object(id));
		float shield = Commands->Get_Shield_Strength(Commands->Find_Object(id));
		const char *pn = Commands->Get_Preset_Name(Commands->Find_Object(id));
		Commands->Destroy_Object(Commands->Find_Object(id));
		GameObject *object;
		object = Commands->Create_Object(pn,Commands->Get_Bone_Position(obj,Get_Parameter("Bone_Name")));
		Commands->Set_Health(object,health);
		Commands->Set_Shield_Strength(object,shield);
		Commands->Set_Facing(object,facing);
		carrying = false;
	}
}

void JFW_CarryAll::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&enabled);
	Auto_Save_Variable(2,1,&carrying);
	Auto_Save_Variable(3,4,&id);
	Auto_Save_Variable(4,4,&pilotID);
}

void JFW_CarryAll::Killed(GameObject *obj,GameObject *shooter)
{
	Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter("Control_ID")),9877,7,0);
}

void JFW_Carry_Control::Created(GameObject *obj)
{
	carryall1 = 0;
	carryall2 = 0;
	carryall3 = 0;
	carryall4 = 0;
	carryall5 = 0;
	carryall6 = 0;
	carryall7 = 0;
	carryall8 = 0;
	carryall9 = 0;
	carryall10 = 0;
	carryall11 = 0;
	carryall12 = 0;
	carryall13 = 0;
	carryall14 = 0;
	carryall15 = 0;
	carryall16 = 0;
	carryall17 = 0;
	carryall18 = 0;
	carryall19 = 0;
	carryall20 = 0;
	carrycount = 0;
}

void JFW_Carry_Control::Custom(GameObject *obj,int message,int param,GameObject *sender)
{
	if (message == 9877 && param == 6)
	{
		carrycount +=1;
		if (carrycount > Get_Int_Parameter("Max_Carryalls"))
		{
			Commands->Send_Custom_Event(obj,sender,9877,7,0);
		}
		if (!carryall1 && Get_Int_Parameter("Max_Carryalls") >=1)
		{
			carryall1 = Commands->Get_ID(sender);
			return;
		}
		if (carryall1 && !carryall2 && Get_Int_Parameter("Max_Carryalls") >=2)
		{
			carryall2 = Commands->Get_ID(sender);
			return;
		}
		if (carryall1 && carryall2 && !carryall3 && Get_Int_Parameter("Max_Carryalls") >=3)
		{
			carryall3 = Commands->Get_ID(sender);
			return;
		}
		if (carryall1 && carryall2 && carryall3 && !carryall4 && Get_Int_Parameter("Max_Carryalls") >=4)
		{
			carryall4 = Commands->Get_ID(sender);
			return;
		}
		if (carryall1 && carryall2 && carryall3 && carryall4 && !carryall5 && Get_Int_Parameter("Max_Carryalls") >=5)
		{
			carryall5 = Commands->Get_ID(sender);
			return;
		}
		if (carryall1 && carryall2 && carryall3 && carryall4 && carryall5 && !carryall6 && Get_Int_Parameter("Max_Carryalls") >=6)
		{
			carryall6 = Commands->Get_ID(sender);
			return;
		}
		if (carryall1 && carryall2 && carryall3 && carryall4 && carryall5 && carryall6 && !carryall7 && Get_Int_Parameter("Max_Carryalls") >=7)
		{
			carryall7 = Commands->Get_ID(sender);
			return;
		}
		if (carryall1 && carryall2 && carryall3 && carryall4 && carryall5 && carryall6 && carryall7 && !carryall8 && Get_Int_Parameter("Max_Carryalls") >=8)
		{
			carryall8 = Commands->Get_ID(sender);
			return;
		}
		if (carryall1 && carryall2 && carryall3 && carryall4 && carryall5 && carryall6 && carryall7 && carryall8 && !carryall9 && Get_Int_Parameter("Max_Carryalls") >=9)
		{
			carryall9 = Commands->Get_ID(sender);
			return;
		}
		if (carryall1 && carryall2 && carryall3 && carryall4 && carryall5 && carryall6 && carryall7 && carryall8 && carryall9 && !carryall10 && Get_Int_Parameter("Max_Carryalls") >=10)
		{
			carryall10 = Commands->Get_ID(sender);
			return;
		}
		if (carryall1 && carryall2 && carryall3 && carryall4 && carryall5 && carryall6 && carryall7 && carryall8 && carryall9 && carryall10 && !carryall11 && Get_Int_Parameter("Max_Carryalls") >=11)
		{
			carryall11 = Commands->Get_ID(sender);
			return;
		}
		if (carryall1 && carryall2 && carryall3 && carryall4 && carryall5 && carryall6 && carryall7 && carryall8 && carryall9 && carryall10 && carryall11 && !carryall12 && Get_Int_Parameter("Max_Carryalls") >=12)
		{
			carryall12 = Commands->Get_ID(sender);
			return;
		}
		if (carryall1 && carryall2 && carryall3 && carryall4 && carryall5 && carryall6 && carryall7 && carryall8 && carryall9 && carryall10 && carryall11 && carryall12 && !carryall13 && Get_Int_Parameter("Max_Carryalls") >=13)
		{
			carryall13 = Commands->Get_ID(sender);
			return;
		}
		if (carryall1 && carryall2 && carryall3 && carryall4 && carryall5 && carryall6 && carryall7 && carryall8 && carryall9 && carryall10 && carryall11 && carryall12 && carryall13 && !carryall14 && Get_Int_Parameter("Max_Carryalls") >=14)
		{
			carryall14 = Commands->Get_ID(sender);
			return;
		}
		if (carryall1 && carryall2 && carryall3 && carryall4 && carryall5 && carryall6 && carryall7 && carryall8 && carryall9 && carryall10 && carryall11 && carryall12 && carryall13 && carryall14 && !carryall15 && Get_Int_Parameter("Max_Carryalls") >=15)
		{
			carryall15 = Commands->Get_ID(sender);
			return;
		}
		if (carryall1 && carryall2 && carryall3 && carryall4 && carryall5 && carryall6 && carryall7 && carryall8 && carryall9 && carryall10 && carryall11 && carryall12 && carryall13 && carryall14 && carryall15 && !carryall16 && Get_Int_Parameter("Max_Carryalls") >=16)
		{
			carryall16 = Commands->Get_ID(sender);
			return;
		}
		if (carryall1 && carryall2 && carryall3 && carryall4 && carryall5 && carryall6 && carryall7 && carryall8 && carryall9 && carryall10 && carryall11 && carryall12 && carryall13 && carryall14 && carryall15 && carryall16 && !carryall17 && Get_Int_Parameter("Max_Carryalls") >=17)
		{
			carryall17 = Commands->Get_ID(sender);
			return;
		}
		if (carryall1 && carryall2 && carryall3 && carryall4 && carryall5 && carryall6 && carryall7 && carryall8 && carryall9 && carryall10 && carryall11 && carryall12 && carryall13 && carryall14 && carryall15 && carryall16 && carryall17 && !carryall18 && Get_Int_Parameter("Max_Carryalls") >=18)
		{
			carryall18 = Commands->Get_ID(sender);
			return;
		}
		if (carryall1 && carryall2 && carryall3 && carryall4 && carryall5 && carryall6 && carryall7 && carryall8 && carryall9 && carryall10 && carryall11 && carryall12 && carryall13 && carryall14 && carryall15 && carryall16 && carryall17 && carryall18 && !carryall19 && Get_Int_Parameter("Max_Carryalls") >=19)
		{
			carryall19 = Commands->Get_ID(sender);
			return;
		}
		if (carryall1 && carryall2 && carryall3 && carryall4 && carryall5 && carryall6 && carryall7 && carryall8 && carryall9 && carryall10 && carryall11 && carryall12 && carryall13 && carryall14 && carryall15 && carryall16 && carryall17 && carryall18 && carryall19 && !carryall20 && Get_Int_Parameter("Max_Carryalls") >=20)
		{
			carryall20 = Commands->Get_ID(sender);
			return;
		}
	}
	if (message == 9877 && param == 7)
	{
		carrycount -= 1;
		if (carryall1 == Commands->Get_ID(sender))
		{
			carryall1 = 0;
		}
		if (carryall2 == Commands->Get_ID(sender))
		{
			carryall2 = 0;
		}
		if (carryall3 == Commands->Get_ID(sender))
		{
			carryall3 = 0;
		}
		if (carryall4 == Commands->Get_ID(sender))
		{
			carryall4 = 0;
		}
		if (carryall5 == Commands->Get_ID(sender))
		{
			carryall5 = 0;
		}
		if (carryall6 == Commands->Get_ID(sender))
		{
			carryall6 = 0;
		}
		if (carryall7 == Commands->Get_ID(sender))
		{
			carryall7 = 0;
		}
		if (carryall8 == Commands->Get_ID(sender))
		{
			carryall8 = 0;
		}
		if (carryall9 == Commands->Get_ID(sender))
		{
			carryall9 = 0;
		}
		if (carryall10 == Commands->Get_ID(sender))
		{
			carryall10 = 0;
		}
		if (carryall11 == Commands->Get_ID(sender))
		{
			carryall11 = 0;
		}
		if (carryall12 == Commands->Get_ID(sender))
		{
			carryall12 = 0;
		}
		if (carryall13 == Commands->Get_ID(sender))
		{
			carryall13 = 0;
		}
		if (carryall14 == Commands->Get_ID(sender))
		{
			carryall14 = 0;
		}
		if (carryall15 == Commands->Get_ID(sender))
		{
			carryall15 = 0;
		}
		if (carryall16 == Commands->Get_ID(sender))
		{
			carryall16 = 0;
		}
		if (carryall17 == Commands->Get_ID(sender))
		{
			carryall17 = 0;
		}
		if (carryall18 == Commands->Get_ID(sender))
		{
			carryall18 = 0;
		}
		if (carryall19 == Commands->Get_ID(sender))
		{
			carryall19 = 0;
		}
		if (carryall20 == Commands->Get_ID(sender))
		{
			carryall20 = 0;
		}
	}
	if (message == 9876)
	{
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall1),9876,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall2),9876,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall3),9876,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall4),9876,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall5),9876,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall6),9876,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall7),9876,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall8),9876,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall9),9876,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall10),9876,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall11),9876,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall12),9876,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall13),9876,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall14),9876,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall15),9876,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall16),9876,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall17),9876,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall18),9876,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall19),9876,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall20),9876,param,0);
		
	}
	if (message == 9875)
	{
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall1),9875,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall2),9875,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall3),9875,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall4),9875,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall5),9875,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall6),9875,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall7),9875,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall8),9875,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall9),9875,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall10),9875,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall11),9875,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall12),9875,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall13),9875,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall14),9875,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall15),9875,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall16),9875,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall17),9875,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall18),9875,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall19),9875,param,0);
		Commands->Send_Custom_Event(sender,Commands->Find_Object(carryall20),9875,param,0);
		
	}
}

void JFW_Carry_Control::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&carryall1);
	Auto_Save_Variable(2,4,&carryall2);
	Auto_Save_Variable(3,4,&carryall3);
	Auto_Save_Variable(4,4,&carryall4);
	Auto_Save_Variable(5,4,&carryall5);
	Auto_Save_Variable(6,4,&carryall6);
	Auto_Save_Variable(7,4,&carryall7);
	Auto_Save_Variable(8,4,&carryall8);
	Auto_Save_Variable(9,4,&carryall9);
	Auto_Save_Variable(10,4,&carryall10);
	Auto_Save_Variable(11,4,&carryall11);
	Auto_Save_Variable(12,4,&carryall12);
	Auto_Save_Variable(13,4,&carryall13);
	Auto_Save_Variable(14,4,&carryall14);
	Auto_Save_Variable(15,4,&carryall15);
	Auto_Save_Variable(16,4,&carryall16);
	Auto_Save_Variable(17,4,&carryall17);
	Auto_Save_Variable(18,4,&carryall18);
	Auto_Save_Variable(19,4,&carryall19);
	Auto_Save_Variable(20,4,&carryall20);
}

void JFW_Sensor_Array::Created(GameObject *obj) 
{
	Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),Get_Int_Parameter("TimerNum"));
}

void JFW_Sensor_Array::Timer_Expired(GameObject *obj,int number)
{
	if (number == Get_Int_Parameter("TimerNum"))
	{
		Vector3 v;
		v.X = 0;
		v.Y = 0;
		v.Z = Get_Float_Parameter("IndicatorZOffset");
		Create_Effect_All_Stealthed_Objects_Area(Commands->Get_Position(obj),Get_Float_Parameter("Distance"),Get_Parameter("Indicator"),v,Get_Int_Parameter("Player_Type"));
		Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),Get_Int_Parameter("TimerNum"));
	}
}

ScriptRegistrant<JFW_Domination_Controler_End_Game> JFW_Domination_Controler_End_Game_Registrant("JFW_Domination_Controler_End_Game","NeutralMessage:int,OwnedMessage:int,Time:float,TimerNum:int,PointsToGive:float,PointsToTake:float,GDIObjectID:int,NodObjectID:int,ZoneCount:int");
ScriptRegistrant<JFW_Carryable_Vehicle> JFW_Carryable_Vehicle_Registrant("JFW_Carryable_Vehicle","Only_Empty:int,Control_ID:int");
ScriptRegistrant<JFW_CarryAll> JFW_CarryAll_Registrant("JFW_CarryAll","Bone_Name:string,Cost:int,Control_ID:int");
ScriptRegistrant<JFW_Carry_Control> JFW_Carry_Control_Registrant("JFW_Carry_Control","Max_Carryalls:int");
ScriptRegistrant<JFW_Sensor_Array> JFW_Sensor_Array_Registrant("JFW_Sensor_Array","Distance:float,Indicator:string,IndicatorZOffset:float,Time:float,TimerNum:int,Player_Type:int");
ScriptRegistrant<JFW_Team_DM_Controller_2> JFW_Team_DM_Controller_2_Registrant("JFW_Team_DM_Controller_2","Deaths_To_Loose:int,Death_Message:int,Team:int");
ScriptRegistrant<JFW_Vehicle_Thief> JFW_Vehicle_Thief_Registrant("JFW_Vehicle_Thief","Weapon:string,Player_Type:int");
ScriptRegistrant<JFW_Vehicle_Thief_2> JFW_Vehicle_Thief_2_Registrant("JFW_Vehicle_Thief_2","Weapon:string,Player_Type:int,Sound:string");
ScriptRegistrant<JFW_Conyard> JFW_Conyard_Registrant("JFW_Conyard","Time:float,TimerNum:int,DisableCustom:int,Health:float");
ScriptRegistrant<JFW_Flying_Infantry> JFW_Flying_Infantry_Registrant("JFW_Flying_Infantry","");
ScriptRegistrant<JFW_Flying_Infantry_Custom> JFW_Flying_Infantry_Custom_Registrant("JFW_Flying_Infantry_Custom","Message:int");
ScriptRegistrant<JFW_Flying_Infantry_Powerup> JFW_Flying_Infantry_Powerup_Registrant("JFW_Flying_Infantry_Powerup","");
ScriptRegistrant<JFW_Flying_Infantry_Enter> JFW_Flying_Infantry_Enter_Registrant("JFW_Flying_Infantry_Enter","Player_Type:int");
ScriptRegistrant<JFW_Flying_Infantry_Exit> JFW_Flying_Infantry_Exit_Registrant("JFW_Flying_Infantry_Exit","Player_Type:int");
ScriptRegistrant<JFW_Drone_Damage> JFW_Drone_Damage_Registrant("JFW_Drone_Damage","RepairStop:int,Preset:string,Amount:int,Custom:int");
ScriptRegistrant<JFW_Conyard_Vehicle_Buildings> JFW_Conyard_Vehicle_Buildings_Registrant("JFW_Conyard_Vehicle_Buildings","Time:float,TimerNum:int,DisableCustom:int,Health:float,Message:int");
ScriptRegistrant<JFW_Domination_Zone> JFW_Domination_Zone_Registrant("JFW_Domination_Zone","Controler_ID:int,NeutralMessage:int,OwnedMessage:int,Nod_Model:string,GDI_Model:string,Neutral_Model:string,Capture_Delay_Time:float,TimerNum:int");
ScriptRegistrant<JFW_Domination_Controler> JFW_Domination_Controler_Registrant("JFW_Domination_Controler","NeutralMessage:int,OwnedMessage:int,Time:float,TimerNum:int,PointsToGive:float,PointsToTake:float,GDIObjectID:int,NodObjectID:int");
ScriptRegistrant<JFW_Iron_Curtain_Zone> JFW_Iron_Curtain_Zone_Registrant("JFW_Iron_Curtain_Zone","Time:float,TimerNum:int,Animation1:string,Animation1Loc:vector3,Animation1Facing:float,Animation1Slot:int,Animation2:string,Animation2Loc:vector3,Animation2Facing:float,Animation2Slot:int,Player_Type:int,Animation3:string,Animation3Loc:vector3,Animation3Facing:float,Animation3Slot:int,BuildingID:int,Invunlerability_Time:float,Invunlerability_TimerNum:int,Animation1Msg:int,Animation2Msg:int,Animation3Msg:int,OffID:int,OnID:int,CinematicPowerOff:int");
ScriptRegistrant<JFW_Chrono_Controler_Zone> JFW_Chrono_Controler_Zone_Registrant("JFW_Chrono_Controler_Zone","Spawner_Time:float,Spawner_TimerNum:int,Spawner_Preset:string,Spawner_Location:vector3,Chrono_Time:float,Chrono_TimerNum:int,Message:int,Animation1:string,Animation1Loc:vector3,Animation1Facing:float,Animation1Slot:int,Animation2:string,Animation2Loc:vector3,Animation2Facing:float,Animation2Slot:int,Animation3:string,Animation3Loc:vector3,Animation3Facing:float,Animation3Slot:int,BuildingID:int,ZAdjust:float,Animation1Msg:int,Animation2Msg:int,Animation3Msg:int,OffID:int,OnID:int,CinematicPowerOff:int,Activate_Time:float,Activate_TimerNum:int,DeathMessage:int");
ScriptRegistrant<JFW_Assault_Powerplant_Controller> JFW_Assault_Powerplant_Controller_Registrant("JFW_Assault_Powerplant_Controller","Time:float,TimerNum:int,Player_Type:int,Power_Off:int,Power_On:int,Building1:int,Building2:int,Building3:int,Building4:int,Building5:int,Building6:int,Building7:int,Building8:int,Building9:int,Building10:int,Building11:int,Building12:int,Building13:int,Building14:int,Building15:int");
ScriptRegistrant<JFW_Resource_Collector> JFW_Resource_Collector_Registrant("JFW_Resource_Collector","Collected_Mesasge:int,Refinery_Message:int,Cash_Limit:int,Cash_Type:int,Entire_Team:int");
ScriptRegistrant<JFW_Resource_Refinery> JFW_Resource_Refinery_Registrant("JFW_Resource_Refinery","Refinery_Message:int");
ScriptRegistrant<JFW_Resource_Field> JFW_Resource_Field_Registrant("JFW_Resource_Field","Cash:int,Time:float,TimerNum:int,Collected_Preset:string,Collected_Preset_Distance:float,Collected_Message:int,Nod_Preset:string,GDI_Preset:string,StartHarvest:int,StopHarvest:int");
ScriptRegistrant<JFW_Team_DM_Controller> JFW_Team_DM_Controller_Registrant("JFW_Team_DM_Controller","Deaths_To_Loose:int,Death_Message:int,Building_To_Destroy1:int,Building_To_Destroy2:int,Building_To_Destroy3:int,Building_To_Destroy4:int,Building_To_Destroy5:int");
ScriptRegistrant<JFW_Team_DM_Zone> JFW_Team_DM_Zone_Registrant("JFW_Team_DM_Zone","Player_Type:int,Controller_ID:int,Deactivate_Message:int,Death_Message:int");
ScriptRegistrant<JFW_Team_DM_Attatched> JFW_Team_DM_Attatched_Registrant("JFW_Team_DM_Attatched","Controller_ID:int,Deactivate_Message:int,Death_Message:int");
