/*	Renegade Scripts.dll
	Scripts by WhiteDragon(MDB)
	Copyright 2006 TheKGBspy, Jonathan Wilson, WhiteDragon(MDB)

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/
#include "scripts.h"
#include "engine.h"
#include "mdb.h"

struct Scope {
	char *Weapon;
	int Num;
};

SimpleDynVecClass<Scope*> Scopes = SimpleDynVecClass<Scope *>(0);

int LookupScopeByWeapon(const char *Weap)
{
	if (!Scopes.Length())
	{
		return -2;
	}
	int x = Scopes.Length();
	for (int i = 0; i < x; i++)
	{
		if (!stricmp(Scopes[i]->Weapon,Weap))
		{
			return Scopes[i]->Num;
		}
	}
	return -2;
}

char *LookupScopeByNumber(int Num)
{
	if (!Scopes.Length())
	{
		return "none";
	}
	int x = Scopes.Length();
	for (int i = 0; i < x; i++)
	{
		if (Scopes[i]->Num == Num)
		{
			return Scopes[i]->Weapon;
		}
	}
	return "none";
}

void LoadScopes()
{
	int handle = Commands->Text_File_Open("weaponscope.cfg");
	if (!handle)
	{
		return;
	}
	char data[100];
	while (Commands->Text_File_Get_String(handle,data,100))
	{
		Scope *s = new Scope;
		char *a = strtok(data,"=");
		char *b = strtok(NULL,"=");
		s->Weapon = newstr(a);
		b[strlen(b)-2] = 0;
		s->Num = atoi(b);
		Scopes.Add(s);
	}
	Commands->Text_File_Close(handle);
}

void MDB_Weapon_Scope::Created(GameObject *obj)
{
	int Temp = Get_Int_Parameter("Default_Scope");
	Set_Scope(obj,Temp);
	CurrScope = Temp;
	Commands->Start_Timer(obj,this,1.0f,1);
}

void MDB_Weapon_Scope::Timer_Expired(GameObject *obj,int number)
{
	int Temp = LookupScopeByWeapon(Get_Current_Weapon(obj));
	if (Temp == -2)
	{
		int Temp2 = Get_Int_Parameter("Default_Scope");
		if (CurrScope != Temp2)
		{
			Set_Scope(obj,Temp2);
			CurrScope = Temp2;
		}
	}
	else if (CurrScope != Temp)
	{
		Set_Scope(obj,Temp);
		CurrScope = Temp;
	}
	Commands->Start_Timer(obj,this,1.0f,1);
}

void MDB_Weapon_Scope::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&CurrScope);
}

void MDB_Change_Spawn_Char_Custom::Custom(GameObject *obj, int message, int param, GameObject *sender)
{
	if (message == Get_Int_Parameter("Message"))
	{
		Change_Spawn_Char(param,Get_Parameter("Character"));
	}
}

void MDB_Change_Spawn_Char_Timer::Created(GameObject *obj)
{
	Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),1);
}

void MDB_Change_Spawn_Char_Timer::Timer_Expired(GameObject *obj, int number)
{
	if (number == 1)
	{
		Change_Spawn_Char(Get_Int_Parameter("Team"),Get_Parameter("Character"));
	}
}

void MDB_ConYard::Created(GameObject *obj)
{
	if (created != 1337)
	{
		Time = Get_Float_Parameter("Interval");
		Amount = Get_Float_Parameter("Heal_Amount");
		Self = Get_Int_Parameter("Repair_Self");
		PMode = Get_Int_Parameter("Power_Mode");
		Commands->Start_Timer(obj,this,Time,1);
		created = 1337;
	}
}

void MDB_ConYard::Timer_Expired(GameObject *obj, int number)
{
	if (!Commands->Get_Building_Power(obj) && PMode != 1)
	{
		if (PMode == 0)
		{
			Destroy_Script();
			return;
		}
		else if (PMode == 2)
		{
			Amount = (Amount*Get_Float_Parameter("Power_Amount"));
		}
		else if (PMode == 3)
		{
			Time = (Time*Get_Float_Parameter("Power_Amount"));
		}
		PMode = 1;
	}
	Repair_All_Buildings_By_Team(Get_Object_Type(obj),Self?0:Commands->Get_ID(obj),Amount);
	Commands->Start_Timer(obj,this,Time,1);
}

void MDB_ConYard::Killed(GameObject *obj,GameObject *shooter)
{
	Amount = 0.0f;
	Destroy_Script();
}

void MDB_ConYard::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&PMode);
	Auto_Save_Variable(2,4,&created);
	Auto_Save_Variable(3,4,&Time);
	Auto_Save_Variable(4,4,&Amount);
	Auto_Save_Variable(5,1,&Self);
}

ScriptRegistrant<MDB_Weapon_Scope> MDB_Weapon_Scope_Registrant("MDB_Weapon_Scope","Default_Scope=-1:int");
ScriptRegistrant<MDB_Change_Spawn_Char_Custom> MDB_Change_Spawn_Char_Custom_Registrant("MDB_Change_Spawn_Char_Custom","Message=0:int,Character:string");
ScriptRegistrant<MDB_Change_Spawn_Char_Timer> MDB_Change_Spawn_Char_Timer_Registrant("MDB_Change_Spawn_Char_Timer","Time=0:float,Team=-1:int,Character:string");
ScriptRegistrant<MDB_ConYard> MDB_ConYard_Registrant("MDB_ConYard","Interval=5.0:float,Heal_Amount=5.0:float,Power_Mode=1:int,Power_Amount=0.0:float,Repair_Self=0:int");
