/*********
Upscales the previous target by a factor of 8 before combining it with the original scene. Use with GenericPostProccessShaderClass.
**********/
texture SceneBuffer: SceneTexture;
texture InputBuffer: InputTexture;

sampler2D SceneBufferSampler =
sampler_state
{
    Texture = <SceneBuffer>;
    AddressU = Clamp;
    AddressV = Clamp;
    MinFilter = Point;
    MagFilter = Linear;
    MipFilter = Linear;
};

sampler2D InputBufferSampler = sampler_state
{
    Texture = <InputBuffer>;
    AddressU = Clamp;
    AddressV = Clamp;
    MinFilter = Point;
    MagFilter = Linear;
    MipFilter = Linear;
};

float4 CombinePS(float2 Tex: TEXCOORD0, float2 Tex2: TEXCOORD1): COLOR0
{
    float3 ColorOrig = tex2D(SceneBufferSampler, Tex2);
    ColorOrig += tex2D(InputBufferSampler, Tex);
    return float4(ColorOrig, 1.0f);
}

technique SceneShader
{
    pass p0
    <
        float ScaleX = 8.0f;
        float ScaleY = 8.0f;
    >
    {
        PixelShader = compile ps_2_0 CombinePS();
    }
}