/*********
BrightPass filter
Use with BrightPassPostProccessShaderClass.
**********/
texture SceneBuffer: SceneTexture;
texture InputBuffer: InputTexture;

sampler2D SceneBufferSampler =
sampler_state
{
    Texture = <SceneBuffer>;
    AddressU = Clamp;
    AddressV = Clamp;
    MinFilter = Point;
    MagFilter = Linear;
    MipFilter = Linear;
};

sampler2D InputBufferSampler = sampler_state
{
    Texture = <InputBuffer>;
    AddressU = Clamp;
    AddressV = Clamp;
    MinFilter = Point;
    MagFilter = Linear;
    MipFilter = Linear;
};

float Luminance: Luminance = 0.08f;
static const float fMiddleGray = 0.18f;
static const float fWhiteCutoff = 0.8f;

float4 BrightPassFilterPS(float2 Tex: TEXCOORD0): COLOR0
{
    float3 ColorOut = tex2D(InputBufferSampler, Tex);
    ColorOut *= fMiddleGray / (Luminance + 0.001f);
    ColorOut *= (1.0f + (ColorOut / (fWhiteCutoff * fWhiteCutoff)));
    ColorOut -= 5.0f;
    ColorOut = max(ColorOut, 0.0f);
    ColorOut /= (10.0f + ColorOut);
    return float4(ColorOut, 1.0f);
}

technique SceneShader
{
    pass p0
    {
        PixelShader = compile ps_2_0 BrightPassFilterPS();
    }
}
