/*********
Downscale with multi-sampling post process shader. This shader takes the source image, 
and downscales it 8 times while multi-sampling the image. Use with GenericPostProccessShaderClass.
**********/
texture SceneBuffer: SceneTexture;
texture InputBuffer: InputTexture;

sampler2D SceneBufferSampler =
sampler_state
{
    Texture = <SceneBuffer>;
    AddressU = Clamp;
    AddressV = Clamp;
    MinFilter = Point;
    MagFilter = Linear;
    MipFilter = Linear;
};

sampler2D InputBufferSampler = sampler_state
{
    Texture = <InputBuffer>;
    AddressU = Clamp;
    AddressV = Clamp;
    MinFilter = Point;
    MagFilter = Linear;
    MipFilter = Linear;
};

float2 PixelCoordsDownFilter[16] =
{
    { 1.5,  -1.5 },
    { 1.5,  -0.5 },
    { 1.5,   0.5 },
    { 1.5,   1.5 },

    { 0.5,  -1.5 },
    { 0.5,  -0.5 },
    { 0.5,   0.5 },
    { 0.5,   1.5 },

    {-0.5,  -1.5 },
    {-0.5,  -0.5 },
    {-0.5,   0.5 },
    {-0.5,   1.5 },

    {-1.5,  -1.5 },
    {-1.5,  -0.5 },
    {-1.5,   0.5 },
    {-1.5,   1.5 },
};

float2 TexelCoordsDownFilter[16]
<
    string ConvertPixelsToTexels = "PixelCoordsDownFilter";
>;

//-----------------------------------------------------------------------------
// Pixel Shader: DownFilter with multisample
//-----------------------------------------------------------------------------
float4 DownFilterPS(float2 Tex: TEXCOORD0): COLOR0
{
    float4 Color = 0;
    for (int i = 0; i < 16; i++)
    {
        Color += tex2D(InputBufferSampler, Tex + TexelCoordsDownFilter[i].xy);
    }
    return Color / 16;
}

technique SceneShader
{
    pass p0
    <
        float ScaleX = 0.125f;
        float ScaleY = 0.125f;
    >
    {
        PixelShader = compile ps_2_0 DownFilterPS();
    }
}
