/*********
Toon Post Process filter <-nearly the same as the edge detect but with additional stuff
Adapted from: http://www.truevision3d.com/forums/announcements/hlsl_post_process_shaders_for_newbies-t18745.0.html;msg128846#msg128846
**********/
texture SceneBuffer: SceneTexture;
texture InputBuffer: InputTexture;

sampler2D SceneBufferSampler =
sampler_state
{
    Texture = <SceneBuffer>;
    AddressU = Clamp;
    AddressV = Clamp;
    MinFilter = Point;
    MagFilter = Linear;
    MipFilter = Linear;
};

sampler2D InputBufferSampler = sampler_state
{
    Texture = <InputBuffer>;
    AddressU = Clamp;
    AddressV = Clamp;
    MinFilter = Point;
    MagFilter = Linear;
    MipFilter = Linear;
};

static const int g_cKernelSize = 7;

float2 PixelKernel[g_cKernelSize] =
{
    { -3, 0 },
    { -2, 0 },
    { -1, 0 },
    {  0, 0 },
    {  1, 0 },
    {  2, 0 },
    {  3, 0 },
};

float2 TexelKernel[g_cKernelSize]
<
    string ConvertPixelsToTexels = "PixelKernel";
>;

static const float BlurWeights[g_cKernelSize] = 
{
    0.064759,
    0.120985,
    0.176033,
    0.199471,
    0.176033,
    0.120985,
    0.064759,
};

float BloomScale: BloomScale = 1.5f;

float4 ColorBlend = float4(15,15,15,0.16f);//For toons

float4 PostProcessPS(float2 Tex: TEXCOORD0) : COLOR0
{
//edited by nopol10
	half4 color = tex2D(InputBufferSampler,Tex.xy);
	color.r = round(color.r*ColorBlend.r)/ColorBlend.r;
	color.g = round(color.g*ColorBlend.g)/ColorBlend.g;
	color.b = round(color.b*ColorBlend.b)/ColorBlend.b;
	
	const float threshold = ColorBlend.w;

	const int NUM = 9;
	const float2 c[NUM] =
	{
		float2(-0.0078125, 0.0078125), 
		float2( 0.00 ,     0.0078125),
		float2( 0.0078125, 0.0078125),
		float2(-0.0078125, 0.00 ),
		float2( 0.0,       0.0),
		float2( 0.0078125, 0.007 ),
		float2(-0.0078125,-0.0078125),
		float2( 0.00 ,    -0.0078125),
		float2( 0.0078125,-0.0078125),
	};	

	int i;
	float3 col[NUM];
	for (i=0; i < NUM; i++)
	{
		col[i] = tex2D(InputBufferSampler, Tex.xy + 0.2*c[i]);
	}
	
	float3 rgb2lum = float3(0.30, 0.59, 0.11);
	float lum[NUM];
	for (i = 0; i < NUM; i++)
	{
		lum[i] = dot(col[i].xyz, rgb2lum);
	}
	float x = lum[2]+  lum[8]+2*lum[5]-lum[0]-2*lum[3]-lum[6];
	float y = lum[6]+2*lum[7]+  lum[8]-lum[0]-2*lum[1]-lum[2];
	float edge =(x*x + y*y < threshold)? 1.0:0.0;
	
	color.rgb *= edge;
	return color;

}

technique SceneShader
{
    pass p0
    {
        PixelShader = compile ps_2_0 PostProcessPS();
    }
}
